% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utrecht2019datasetDescriptiveStatistics.R
\name{Utrecht2019datasetDescriptiveStatistics}
\alias{Utrecht2019datasetDescriptiveStatistics}
\title{Utrecht2019datasetDescriptiveStatistics}
\usage{
Utrecht2019datasetDescriptiveStatistics(show = "all")
}
\arguments{
\item{show}{character string for the type of statistic to show.
There are three options:
\itemize{
\item 'continuous', summary statistic for continuous variables will be displayed.
\item 'categorical', frequency tables for categorical variables will be displayed.
\item 'all', both summary will be displayed.
\item none of the above a warning will be launched.
}}
}
\value{
A list or an object depending on the value of \code{show}:
- If \code{show = "continuous"} A data frame with descriptive statistics.
- If \code{show = "categorical"} A list of frequency tables.
- If \code{show = "all"} A list of 2 items,
the first is a data frame for continuous variable,
the second is a list for categorical variables.
- If show is not one of the above return a warning.
}
\description{
Provides descriptive statistics for the 'utrecht2019dataset'.
It can display summary statistic for continuous variables, frequency tables for categorical variables
or both.
}
\examples{
  # Show both continuous and categorical stats
  all <- Utrecht2019datasetDescriptiveStatistics(show = "all")

  # Mean value for the OS_months columns
  all$continuous["Mean", "OS_months"]

  # Min, Median and Max value for ALL the numeric columns
  all$continuous[c("Min","Median","Max"),]

  # Get the frequency table of the third categorical column
  all$categorical[[3]]

  # Only continuous variables
  cont <- Utrecht2019datasetDescriptiveStatistics("continuous")

  # Statistics for age_years column
  cont[, "age_years"]

  # Only categorical variables
  cat <- Utrecht2019datasetDescriptiveStatistics("categorical")

  # Frequency values for all factors of the second categorical column
  cat[[2]][,"Freq"]

  # Statistics for the Yes factor of the second categorical column
  cat[[2]]["Monotherapy",]

  # Frequency of the No factor, a value of the second categorical column
  cat[[2]]["RT+TMZ", "Freq"]

}
\seealso{
\code{\link[summarytools:descr]{summarytools::descr()}}, \code{\link[summarytools:freq]{summarytools::freq()}}
}
