% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meningitis.R
\docType{data}
\name{meningitis}
\alias{meningitis}
\title{meningitis- Meningococcal Disease Data with missing data in the response variable}
\format{
A data frame with several rows and columns representing various variables:
\describe{
\item{CaseCntrl}{Case control status}
\item{Numnill}{Number of illnesses}
\item{Numsleep}{Number of sleep disturbances}
\item{Smoke}{Smoking status}
\item{Set}{Set variable}
\item{Reftime}{Reference time}
}
}
\usage{
meningitis
}
\description{
The dataset meningitis is from a brief outbreak of meningococcal disease at the University of Illinois, Urbana-Champaign campus in the years 1991 and 1992. The dataset is available in the LogXact software and also analyzed in Imrey et al. (1996). Maiti and Pradhan (2009) fitted a logistic regression using the model CaseCntrl ~ Numill + Numsleep + Smoke + Set + Reftime.
}
\examples{
# Examples using Firth (1993) type bias reduction. Complete case analysis or
# biascorrection=FALSE encounters separation
fit <- emBinRegMAR(CaseCntrl~Numnill+Numsleep+Smoke+Set+Reftime,
                        data=meningitis, biascorrectn=TRUE)
# display summary of the beta estimates of the model
fit$beta
# display summary of the alpha estimates of the model used
# for non-ignorability setting of the missing responses
fit$alpha
}
\references{
Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.

Imrey, P. B., Jackson, L. A., Ludwinski, P. H., England, A. C. II, Fox, B. C., Isdale, L. B., Reeves, M. W., and Wenger, J. D. (1996). Outbreak of serogroup C meningococcal disease associated with campus bar patronage. American Journal of Epidemiology 143, 624–630.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2024). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
}
\keyword{datasets}
