% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_helpers.R
\name{glmmfe_lmm_inner_fit}
\alias{glmmfe_lmm_inner_fit}
\title{Internal Gaussian inner fit for PL / weighted LMM with G = tau2 * I}
\usage{
glmmfe_lmm_inner_fit(
  z_work,
  w_num,
  X,
  Z,
  tau2,
  approx = c("RSPL", "MSPL"),
  vc_eps = 1e-12,
  ridge_init = 1e-08
)
}
\description{
Model (conditional on working quantities):
\deqn{z_{\mathrm{work}} = X\beta + Z\eta + e,\qquad e \sim N(0, W^{-1})}
\deqn{\eta \sim N(0, \tau^2 I_q)}
}
\details{
where \eqn{W = \mathrm{diag}(w_{\mathrm{num}})}.

Returns \code{beta}, \code{eta} and covariance blocks needed by RSPL/MSPL updates.
Does NOT form \eqn{n \times n} matrices.
}
\keyword{internal}
