% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{sandwich}
\alias{sandwich}
\alias{sandwich.default}
\alias{sandwich.glmmTMB}
\title{Sandwich Estimator based on Bread and Meat Matrices}
\usage{
sandwich(x, ...)

\method{sandwich}{default}(x, ...)

\method{sandwich}{glmmTMB}(x, full = FALSE, cluster = getGroups(x), rawnames = FALSE, ...)
}
\arguments{
\item{x}{a \code{glmmTMB} object fitted with ML (REML is not supported).}

\item{...}{ignored by the \code{glmmTMB} method.}

\item{full}{logical; if \code{TRUE}, return the full sandwich matrix including variance components,
otherwise only the fixed effects part (if the model was fit with ML).}

\item{cluster}{a factor indicating the cluster structure of the data.}

\item{rawnames}{logical; if \code{TRUE}, keep the original names of the parameters as in the 
\code{TMB} object. By default, \code{FALSE} such that the names are sanitized to user friendly names.}
}
\value{
A square matrix representing the sandwich estimator.
}
\description{
This (simplified) method for a new S3 generic based on \code{\link[sandwich]{sandwich}} 
computes the sandwich estimator for a fitted \code{glmmTMB} model.
}
\examples{
m <- glmmTMB(count ~ mined + (1 | site), data = Salamanders, family = nbinom1)
sandwich(m)
sandwich(m, full = TRUE)
}
