% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_message.R
\name{gm_save_attachments}
\alias{gm_save_attachments}
\title{Save attachments to a message}
\usage{
gm_save_attachments(x, attachment_id = NULL, path = ".", user_id = "me")
}
\arguments{
\item{x}{message with attachment}

\item{attachment_id}{id of the attachment to save, if none specified saves all attachments}

\item{path}{where to save the attachments}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Function to retrieve and save all of the attachments to a message by id of the message.
}
\examples{
\dontrun{
# save all attachments
gm_save_attachments(my_message)
# save a specific attachment
gm_save_attachments(my_message, "a32e324b")
}
}
\references{
\url{https://developers.google.com/gmail/api/reference/rest/v1/users.messages.attachments/get}
}
\seealso{
Other message: 
\code{\link{gm_attachment}()},
\code{\link{gm_delete_message}()},
\code{\link{gm_import_message}()},
\code{\link{gm_insert_message}()},
\code{\link{gm_message}()},
\code{\link{gm_messages}()},
\code{\link{gm_modify_message}()},
\code{\link{gm_save_attachment}()},
\code{\link{gm_send_message}()},
\code{\link{gm_trash_message}()},
\code{\link{gm_untrash_message}()}
}
\concept{message}
