% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_ontology.R
\name{treemap_plot}
\alias{treemap_plot}
\title{Plot a treemap}
\usage{
treemap_plot(x, label_group = FALSE)
}
\arguments{
\item{x}{\code{treemap_plotdata} data table that was computed by the \code{treemap_data()} function}

\item{label_group}{set TRUE to show only group-level labels}
}
\value{
a ggplot2 object constructed by \code{treemap::treemap()}
}
\description{
simple wrapper around the treemap R package. To customize this plot, copy/paste its code and tweak parameters as desired
}
\examples{
\donttest{
# note; this example downloads data when first run, and typically takes ~60seconds

# store the downloaded files in the following directory. Here, the temporary file
# directory is used. Alternatively, consider storing this data in a more permanent location.
# e.g. output_dir="~/data/goat" on unix systems or output_dir="C:/data/goat" on Windows
output_dir = tempdir()

## first run the default example from test_genesets() to obtain geneset results
datasets = download_goat_manuscript_data(output_dir)
if(!is.null(datasets)) {
genelist = datasets$`Wingo 2020:mass-spec:PMID32424284`
genesets_asis = download_genesets_goatrepo(output_dir)
if(!is.null(genesets_asis)) {
genesets_filtered = filter_genesets(genesets_asis, genelist)
result = test_genesets(genesets_filtered, genelist, method = "goat",
  score_type = "effectsize", padj_method = "bonferroni", padj_cutoff = 0.05)

# subset GO CC results
x = result |> filter(signif & source == "GO_CC")
tm = treemap_data(
  geneset_ids = x$id,
  genesets = genesets_filtered,
  genesets_test_result = x,
  simplify = "leaf_only" # options: none/leaf_only/prune_singletons/pvalue
)
treemap_plot(tm$treemap_plotdata)
}
}
}
}
