## usethis namespace: start
#' goldfish package
#'
#' The goldfish Project is an R package that allows
#' to fit statistical network models
#' (such as DyNAM and REM) to dynamic network data.
#'
#' The \href{https://sn.ethz.ch/research/software/goldfish.html}{goldfish}
#' package in R allows the study of time-stamped network data
#'  using a variety of models.
#' In particular, it implements different types of
#'  Dynamic Network Actor Models (DyNAMs),
#' a class of models that is tailored to the study of
#'  actor-oriented network processess through time.
#' Goldfish also implements different versions of
#'  the tie-oriented Relational Event Model by Carter Butts.
#'
#' @seealso [estimate()]
#' @references
#' Stadtfeld, C. (2012). Events in Social Networks: A Stochastic
#' Actor-oriented Framework for Dynamic Event Processes in Social Networks.
#' \emph{KIT Scientific Publishing}. \doi{10.5445/KSP/1000025407}
#'
#' Stadtfeld, C., and Block, P. (2017). Interactions, Actors, and Time:
#' Dynamic Network Actor Models for Relational Events.
#' \emph{Sociological Science 4 (1)}, 318-52. \doi{10.15195/v4.a14}
#'
#' Stadtfeld, C., Hollway, J., and Block, P. (2017).
#' Dynamic Network Actor Models: Investigating Coordination Ties Through Time.
#' \emph{Sociological Methodology 47 (1)}. \doi{10.1177/0081175017709295}
#'
#' Hollway, J. (2020).
#' Network embeddedness and the rate
#' of international water cooperation and conflict.
#' In \emph{Networks in Water Governance},
#' edited by Manuel Fischer and Karin Ingold.
#' London: Palgrave, pp. 87-113.
#'
#' Hoffman, M., Block P., Elmer T., and Stadtfeld C. (2020).
#' A model for the dynamics of face-to-face interactions in social groups.
#' \emph{Network Science}, 8(S1), S4-S25. \doi{10.1017/nws.2020.3}
#' @useDynLib goldfish
#' @importFrom Rcpp sourceCpp
#' @importFrom rlang .data
"_PACKAGE"
## usethis namespace: end
NULL
