% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_players.R
\name{load_players}
\alias{load_players}
\title{Load Player Directory}
\usage{
load_players(year = as.integer(format(Sys.Date(), "\%Y")), tour = "pga")
}
\arguments{
\item{year}{Season year to pull players from. Defaults to current year.}

\item{tour}{Tour identifier. Currently supports "pga" (default).}
}
\value{
A tibble with player data including:
  \itemize{
    \item \code{player_id}: ESPN athlete ID
    \item \code{player_name}: Player display name
  }
}
\description{
Retrieves a directory of players for a tour. Since ESPN doesn't have
a dedicated player directory endpoint, this aggregates players from
recent tournament leaderboards.
}
\examples{
\donttest{
# Get player directory
players <- load_players()
}
}
