% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_storage.R
\name{save_to_parquet}
\alias{save_to_parquet}
\title{Save Tournament Data to Parquet}
\usage{
save_to_parquet(data, file_path, append = TRUE)
}
\arguments{
\item{data}{Tibble of tournament data}

\item{file_path}{Path to Parquet file. Must be specified by user.}

\item{append}{If TRUE, append to existing data}
}
\value{
Invisible NULL. Called for side effects (writes to file).
}
\description{
Save tournament data to a Parquet file for cross-language compatibility.
Requires the arrow package.
}
\examples{
\dontrun{
masters <- load_tournament(2025, "Masters")
save_to_parquet(masters, file_path = tempfile(fileext = ".parquet"))
}
}
