% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{gtm_workspaces_preview}
\alias{gtm_workspaces_preview}
\title{Preview the compilation of a container version}
\usage{
gtm_workspaces_preview(account_id, container_id, workspace_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}
}
\value{
Invisibly, the server response. If successful this is list with one element.
}
\description{
Quick previews a workspace by creating a fake container version from all entities in the 
provided workspace. It returns a container object, and if there are any conflicts, sync errors
or compiler errors in the workspace
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 6

preview <- gtm_workspaces_preview(accountId, containerId, workspaceId)

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/quick_preview}

Other workspace functions: 
\code{\link{gtm_workspaces_create}()},
\code{\link{gtm_workspaces_delete}()},
\code{\link{gtm_workspaces_get}()},
\code{\link{gtm_workspaces_list}()},
\code{\link{gtm_workspaces_resolve}()},
\code{\link{gtm_workspaces_status}()},
\code{\link{gtm_workspaces_submit}()},
\code{\link{gtm_workspaces_sync}()},
\code{\link{gtm_workspaces_update}()}
}
\concept{workspace functions}
