% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcut.R
\name{shortcut_resolve}
\alias{shortcut_resolve}
\title{Resolve shortcuts to their targets}
\usage{
shortcut_resolve(file)
}
\arguments{
\item{file}{Something that identifies the file(s) of interest on your Google
Drive. Can be a character vector of names/paths, a character vector of file
ids or URLs marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per file.
Extra columns \code{name_shortcut} and
\code{id_shortcut} refer to the original shortcut.
}
\description{
Retrieves the metadata for the Drive file that a shortcut refers to, i.e. the
shortcut's target. The returned \code{\link{dribble}} has the usual columns (\code{name},
\code{id}, \code{drive_resource}), which refer to the target. It will also include the
columns \code{name_shortcut} and \code{id_shortcut}, which refer to the original
shortcut. There are 3 possible scenarios:
\enumerate{
\item \code{file} is a shortcut and user can \code{\link[=drive_get]{drive_get()}} the target. All is simple
and well.
\item \code{file} is a shortcut, but \code{\link[=drive_get]{drive_get()}} fails for the target. This can
happen if the user can see the shortcut, but does not have read access
to the target. It can also happen if the target has been trashed or
deleted. In such cases, all of the target's metadata, except for \code{id},
will be missing. Call \code{drive_get()} on a problematic \code{id} to see the
specific error.
\item \code{file} is not a shortcut. \code{name_shortcut} and \code{id_shortcut} will both be
\code{NA}.
}
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
# Create a file to make a shortcut to
file <- drive_example_remote("chicken_sheet") |>
  drive_cp(name = "chicken-sheet-for-shortcut")

# Create a shortcut
sc1 <- file |>
  shortcut_create(name = "shortcut-1")

# Create a second shortcut by copying the first
sc1 <- sc1 |>
  drive_cp(name = "shortcut-2")

# Get the shortcuts
(sc_dat <- drive_find("-[12]$", type = "shortcut"))

# Resolve them
(resolved <- shortcut_resolve(sc_dat))

resolved$id
file$id

# Delete the target file
drive_rm(file)

# (Try to) resolve the shortcuts again
shortcut_resolve(sc_dat)
# No error, but resolution is unsuccessful due to non-existent target

# Clean up
drive_rm(sc_dat)
\dontshow{\}) # examplesIf}
}
