% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory_bulk.R
\name{goose_session_start}
\alias{goose_session_start}
\title{Start a gooseR session for tracking saved items}
\usage{
goose_session_start(session_id = NULL)
}
\arguments{
\item{session_id}{Character, optional session identifier}
}
\value{
Character, the session ID
}
\description{
Note: To automatically tag items with the session ID, you need to
manually add the session tag when saving, or use the wrapper functions.
}
\examples{
\dontrun{
# Start a session
session_id <- goose_session_start()

# Save items (manually tag with session)
goose_save(mtcars, "cars_data", category = "analysis", 
           tags = c("myanalysis", getOption("goose.session_id")))

# See what was saved in this session
goose_session_list()

# Clean up session
goose_session_clear()
goose_session_end()
}
}
