% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{GPModel}
\alias{GPModel}
\title{Create a \code{GPModel} object}
\usage{
GPModel(likelihood = "gaussian", group_data = NULL,
  group_rand_coef_data = NULL, ind_effect_group_rand_coef = NULL,
  drop_intercept_group_rand_effect = NULL, gp_coords = NULL,
  gp_rand_coef_data = NULL, cov_function = "matern", cov_fct_shape = 1.5,
  gp_approx = "none", num_parallel_threads = NULL, GPU_use = FALSE,
  matrix_inversion_method = "default", weights = NULL,
  likelihood_learning_rate = 1, cov_fct_taper_range = 1,
  cov_fct_taper_shape = 1, num_neighbors = NULL,
  vecchia_ordering = "random", ind_points_selection = "kmeans++",
  num_ind_points = NULL, cover_tree_radius = 1, seed = 0L,
  cluster_ids = NULL, likelihood_additional_param = NULL, num_data = NULL,
  free_raw_data = FALSE, vecchia_approx = NULL, vecchia_pred_type = NULL,
  num_neighbors_pred = NULL)
}
\arguments{
\item{likelihood}{A \code{string} specifying the likelihood function (distribution) of the response variable. 
Available options:
\itemize{
\item{ "gaussian" }
\item{ "bernoulli_logit": Bernoulli likelihood with a logit link function for binary classification. Aliases: "binary", "binary_logit" }
\item{ "bernoulli_probit": Bernoulli likelihood with a probit link function for binary classification. Aliases: "binary_probit" }
\item{ "binomial_logit": Binomial likelihood with a logit link function. 
The response variable \code{y} needs to contain proportions of successes / trials, 
and the \code{weights} parameter needs to contain the numbers of trials. Aliases: "binomial"}
\item{ "binomial_probit": Binomial likelihood with a probit link function. 
The response variable \code{y} needs to contain proportions of successes / trials, 
and the \code{weights} parameter needs to contain the numbers of trials }
\item{ "beta_binomial": Beta-binomial likelihood with a logit link function. 
The response variable \code{y} needs to contain proportions of successes / trials, 
and the \code{weights} parameter needs to contain the numbers of trials. Aliases: "betabinomial", "beta-binomial"}
\item{ "poisson": Poisson likelihood with a log link function }
\item{ "negative_binomial": negative binomial likelihood with a log link function (aka "nbinom2", "negative_binomial_2"). 
The variance is mu * (mu + r) / r, mu = mean, r = shape, with this parametrization }
\item{ "negative_binomial_1": Negative binomial 1 (aka "nbinom1") likelihood with a log link function. 
The variance is mu * (1 + phi), mu = mean, phi = dispersion, with this parametrization }
\item{ "gamma": Gamma likelihood with a log link function }
\item{ "lognormal": Log-normal likelihood with a log link function }
\item{ "beta" : Beta likelihood with a logit link function (parametrization of Ferrari and Cribari-Neto, 2004)}
\item{ "t": t-distribution (e.g., for robust regression) }
\item{ "t_fix_df": t-distribution with the degrees-of-freedom (df) held fixed and not estimated
\itemize{ \item{ The degrees-of-freedom (df) can be set via the \code{likelihood_additional_param} parameter. The default is df = 2 }}
}
\item{ "quantile_regression" / "asymmetric_laplace" : an asymmetric Laplace likelihood for quantile regression, aliases: "asymmetric_laplace", "quantile_regression" 
\itemize{ \item{ The quantile can be set via the \code{likelihood_additional_param} parameter. The default is quantile = 0.5 }}
}
\item{ "zero_inflated_gamma": Zero-inflated gamma likelihood. 
The log-transformed mean of the response variable equals the sum of fixed and random effects, E(y) = mu = exp(F(X) + Zb), 
and the rate parameter equals (1-p0) * gamma / mu, where p0 is the zero-inflation probability and gamma the shape parameter. 
I.e., the rate parameter depends on F(X) + Zb, and p0 and gamma are (univariate auxiliary) parameters that are estimated. 
Note that E(y) = mu above refers the the mean of the entire distribution and not just the positive part }
\item{ "zero_censored_power_transformed_normal": Likelihood of a censored and power-transformed normal variable 
for modeling data with a point mass at 0 and a continuous distribution for y > 0. 
The model used is Y = max(0,X)^lambda, X ~ N(mu, sigma^2), where mu = F(X) + Zb, 
and sigma and lambda are (auxiliary) parameters that are estimated. 
For more details on this model, see Sigrist et al. (2012, AOAS) "A dynamic nonstationary spatio-temporal model for short term prediction of precipitation" }
\item{ "gaussian_heteroscedastic": Gaussian likelihood where both the mean and the variance 
are related to fixed and random effects. This is currently only implemented for GPs with a 'vecchia' approximation }
\item{ Note: the first lines in the \href{https://github.com/fabsig/GPBoost/blob/master/include/GPBoost/likelihoods.h}{likelihoods source file} contain additional comments on the specific parametrizations used }
\item{ Note: other likelihoods can be implemented upon request }
}}

\item{group_data}{A \code{vector} or \code{matrix} whose columns are categorical grouping variables. 
The elements being group levels defining grouped random effects.
The elements of 'group_data' can be integer, double, or character.
The number of columns corresponds to the number of grouped (intercept) random effects}

\item{group_rand_coef_data}{A \code{vector} or \code{matrix} with numeric covariate data 
for grouped random coefficients}

\item{ind_effect_group_rand_coef}{A \code{vector} with \code{integer} indices that 
indicate the corresponding categorical grouping variable (=columns) in 'group_data' for 
every covariate in 'group_rand_coef_data'. Counting starts at 1.
The length of this index vector must equal the number of covariates in 'group_rand_coef_data'.
For instance, c(1,1,2) means that the first two covariates (=first two columns) in 'group_rand_coef_data'
have random coefficients corresponding to the first categorical grouping variable (=first column) in 'group_data',
and the third covariate (=third column) in 'group_rand_coef_data' has a random coefficient
corresponding to the second grouping variable (=second column) in 'group_data'}

\item{drop_intercept_group_rand_effect}{A \code{vector} of type \code{logical} (boolean). 
Indicates whether intercept random effects are dropped (only for random coefficients). 
If drop_intercept_group_rand_effect[k] is TRUE, the intercept random effect number k is dropped / not included. 
Only random effects with random slopes can be dropped.}

\item{gp_coords}{A \code{matrix} with numeric coordinates (= inputs / features) for defining Gaussian processes}

\item{gp_rand_coef_data}{A \code{vector} or \code{matrix} with numeric covariate data for
Gaussian process random coefficients}

\item{cov_function}{A \code{string} specifying the covariance function for the Gaussian process. 
Available options:
\itemize{
\item{ "matern": Matern covariance function with the smoothness specified by 
the \code{cov_fct_shape} parameter (using the parametrization of Rasmussen and Williams, 2006) }
\item{ "matern_estimate_shape": same as "matern" but the smoothness parameter is also estimated }
\item{ "matern_space_time": Spatio-temporal Matern covariance function with different range parameters for space and time. 
Note that the first column in \code{gp_coords} must correspond to the time dimension }
\item{ "space_time_gneiting": Spatio-temporal covariance function given in Eq. (16) of Gneiting (2002). 
Note that the first column in \code{gp_coords} must correspond to the time dimension. 
This covariance has seven parameters (in the following order: sigma2, a, c, alpha, nu, beta, delta) which are all estimated by default. 
You can disable the estimation of some of these parameter using the 'estimate_cov_par_index' argument of the \code{params} argument in either 
the \code{fit} function of a \code{gp_model} object or the \code{set_optim_params} function prior to estimation. }
\item{ "matern_ard": anisotropic Matern covariance function with Automatic Relevance Determination (ARD), 
i.e., with a different range parameter for every coordinate of \code{gp_coords} }
\item{ "matern_ard_estimate_shape": same as "matern_ard" but the smoothness parameter is also estimated }
\item{ "exponential": Exponential covariance function (using the parametrization of Diggle and Ribeiro, 2007) }
\item{ "gaussian": Gaussian, aka squared exponential, covariance function (using the parametrization of Diggle and Ribeiro, 2007) }
\item{ "gaussian_ard": anisotropic Gaussian, aka squared exponential, covariance function with Automatic Relevance Determination (ARD), 
i.e., with a different range parameter for every coordinate of \code{gp_coords} }
\item{ "powered_exponential": powered exponential covariance function with the exponent specified by 
the \code{cov_fct_shape} parameter (using the parametrization of Diggle and Ribeiro, 2007) }
\item{ "wendland": Compactly supported Wendland covariance function 
(using the parametrization of Bevilacqua et al., 2019, AOS) }
\item{ "linear": linear covariance function. This corresponds to a Bayesian linear 
regression model with a Gaussian prior on the coefficients with a constant variance 
diagonal prior covariance, and the prior variance is estimated using empirical Bayes. }
\item{ "hurst": Hurst covariance function cov(s, s') = (sigma2 / 2) * ( ||s||^(2H) + ||s'||^(2H) - ||s - s'||^(2H) ). 
For H = 0.5, this corresponds to Brownian motion (-> see the 'estimate_cov_par_index' argument) }
\item{ "hurst_ard": Hurst covariance function with with Automatic Relevance Determination (ARD), 
i.e., with a different range parameter for every coordinate of ``gp_coords`` except 
for the first coordinate which has a range parameter of 1 due to identifiability with the marginal variance: 
\eqn{ cov(s, s') = (\sigma^2/2)\left[ \left(s_1^2 + \sum_{k=2}^d (s_k/l_k)^2\right)^H + \left({s'}_1^2 + \sum_{k=2}^d ({s'}_k/l_k)^2\right)^H - \left((s_1-{s'}_1)^2 + \sum_{k=2}^d ((s_k-{s'}_k)/l_k)^2\right)^H \right] } }
}}

\item{cov_fct_shape}{A \code{numeric} specifying the shape parameter of the covariance function 
(e.g., smoothness parameter for Matern and Wendland covariance)  
This parameter is irrelevant for some covariance functions such as the exponential or Gaussian}

\item{gp_approx}{A \code{string} specifying the large data approximation
for Gaussian processes. Available options: 
\itemize{
\item{"none": No approximation }
\item{"vecchia": Vecchia approximation; see Sigrist (2022, JMLR) for more details }
\item{"full_scale_vecchia": Vecchia-inducing points full-scale (VIF) approximation; 
see Gyger, Furrer, and Sigrist (2025) for more details }
\item{"tapering": The covariance function is multiplied by 
a compactly supported Wendland correlation function }
\item{"fitc": Fully Independent Training Conditional approximation aka 
modified predictive process approximation; see Gyger, Furrer, and Sigrist (2024) for more details }
\item{"full_scale_tapering": Full-scale approximation combining an 
inducing point / predictive process approximation with tapering on the residual process; 
see Gyger, Furrer, and Sigrist (2024) for more details }
\item{"vecchia_latent": similar as "vecchia" but a Vecchia approximation is applied to the latent Gaussian process 
for likelihood == "gaussian". For likelihood != "gaussian", "vecchia" and "vecchia_latent" are equivalent }
}}

\item{num_parallel_threads}{An \code{integer} specifying the number of parallel threads for OMP. 
If num_parallel_threads = NULL, all available threads are used}

\item{GPU_use}{A \code{boolean}. If TRUE, GPU acceleration will be used if supported}

\item{matrix_inversion_method}{A \code{string} specifying the method used for inverting covariance matrices. 
Available options:
\itemize{
\item{"default": iterative methods where possible, otherwise Cholesky factorization }
\item{"cholesky": Cholesky factorization }
\item{"iterative": iterative methods. A combination of the conjugate gradient, the Lanczos algorithm, and other methods. 

This is currently only supported for the following cases: 
\itemize{
\item{ grouped random effects with more than one level }
\item{likelihood != "gaussian" and gp_approx == "vecchia" (non-Gaussian likelihoods with a Vecchia-Laplace approximation) }
\item{likelihood != "gaussian" and gp_approx == "full_scale_vecchia" (non-Gaussian likelihoods with a VIF approximation) }
\item{likelihood == "gaussian" and gp_approx == "full_scale_tapering" (Gaussian likelihood with a full-scale tapering approximation) }
}
}
}}

\item{weights}{A \code{vector} with sample weights}

\item{likelihood_learning_rate}{A \code{numeric} with a learning rate for the likelihood for generalized Bayesian inference (only non-Gaussian likelihoods)}

\item{cov_fct_taper_range}{A \code{numeric} specifying the range parameter 
of the Wendland covariance function and Wendland correlation taper function. 
We follow the notation of Bevilacqua et al. (2019, AOS)}

\item{cov_fct_taper_shape}{A \code{numeric} specifying the shape (=smoothness) parameter 
of the Wendland covariance function and Wendland correlation taper function. 
We follow the notation of Bevilacqua et al. (2019, AOS)}

\item{num_neighbors}{An \code{integer} specifying the number of neighbors for 
the Vecchia and VIF approximations. Internal default values if NULL: 
\itemize{
   \item{ 20 for gp_approx = "vecchia" }
   \item{ 30 for gp_approx = "full_scale_vecchia" }
   }
Note: for prediction, the number of neighbors can 
be set through the 'num_neighbors_pred' parameter in the 'set_prediction_data'
function. By default, num_neighbors_pred = 2 * num_neighbors. Further, 
the type of Vecchia approximation used for making predictions is set through  
the 'vecchia_pred_type' parameter in the 'set_prediction_data' function}

\item{vecchia_ordering}{A \code{string} specifying the ordering used in 
the Vecchia approximation. Available options:
\itemize{
\item{"none": the default ordering in the data is used }
\item{"random": a random ordering }
\item{"time": ordering accorrding to time (only for space-time models) }
\item{"time_random_space": ordering according to time and randomly for all 
spatial points with the same time points (only for space-time models) }
}}

\item{ind_points_selection}{A \code{string} specifying the method for choosing inducing points
Available options:
\itemize{
\item{"kmeans++: the k-means++ algorithm }
\item{"cover_tree": the cover tree algorithm }
\item{"random": random selection from data points }
}}

\item{num_ind_points}{An \code{integer} specifying the number of inducing 
points / knots for FITC, full_scale_tapering, and VIF approximations. Internal default values if NULL: 
\itemize{
   \item{ 500 for gp_approx = "FITC" and gp_approx = "full_scale_tapering" }
   \item{ 200 for gp_approx = "full_scale_vecchia" }
   }}

\item{cover_tree_radius}{A \code{numeric} specifying the radius (= "spatial resolution") 
for the cover tree algorithm}

\item{seed}{An \code{integer} specifying the seed used for model creation 
(e.g., random ordering in Vecchia approximation)}

\item{cluster_ids}{A \code{vector} with elements indicating independent realizations of 
random effects / Gaussian processes (same values = same process realization).
The elements of 'cluster_ids' can be integer, double, or character.}

\item{likelihood_additional_param}{A \code{numeric} specifying an additional parameter for the \code{likelihood} 
which cannot be estimated for this \code{likelihood} (e.g., degrees of freedom for \code{likelihood = "t_fix_df"}). 
This is not to be confused with any auxiliary parameters that can be estimated and accessed through 
the function \code{get_aux_pars} after estimation.
Note that this \code{likelihood_additional_param} parameter is irrelevant for many likelihoods.
If \code{likelihood_additional_param = NULL}, the following internal default values are used:
\itemize{
\item{ df = 2 for likelihood = "t_fix_df" }
\item{ quantile = 0.5 for likelihood = "asymmetric_laplace" }
}}

\item{num_data}{A \code{numeric} with the number of samples. This is only used for iid models}

\item{free_raw_data}{A \code{boolean}. If TRUE, the data (groups, coordinates, covariate data for random coefficients) 
is freed in R after initialization}

\item{vecchia_approx}{Discontinued. Use the argument \code{gp_approx} instead}

\item{vecchia_pred_type}{A \code{string} specifying the type of Vecchia approximation used for making predictions.
This is discontinued here. Use the function 'set_prediction_data' to specify this}

\item{num_neighbors_pred}{an \code{integer} specifying the number of neighbors for making predictions.
This is discontinued here. Use the function 'set_prediction_data' to specify this}
}
\value{
A \code{GPModel} containing ontains a Gaussian process and / or mixed effects model with grouped random effects
}
\description{
Create a \code{GPModel} which contains a Gaussian process and / or mixed effects model with grouped random effects
}
\examples{
# See https://github.com/fabsig/GPBoost/tree/master/R-package for more examples

data(GPBoost_data, package = "gpboost")

#--------------------Grouped random effects model: single-level random effect----------------
gp_model <- GPModel(group_data = group_data[,1], likelihood="gaussian")

#--------------------Gaussian process model----------------
gp_model <- GPModel(gp_coords = coords, cov_function = "matern", cov_fct_shape = 1.5,
                    likelihood="gaussian")

#--------------------Combine Gaussian process with grouped random effects----------------
gp_model <- GPModel(group_data = group_data,
                    gp_coords = coords, cov_function = "matern", cov_fct_shape = 1.5,
                    likelihood="gaussian")
}
\author{
Fabio Sigrist
}
