% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{GetSignificantGenes}
\alias{GetSignificantGenes}
\title{Significant genes}
\usage{
GetSignificantGenes(
  data,
  analysis = NULL,
  regex = TRUE,
  criteria = NULL,
  as.table = FALSE,
  use.symbols = TRUE,
  gene.info = TRUE
)
}
\arguments{
\item{data}{the grandR object}

\item{analysis}{the analysis to use, can be more than one and can be regexes (see details)}

\item{regex}{interpret analyses as regex?}

\item{criteria}{the criteria used to define what significant means; if NULL, Q<0.05 & abs(LFC)>=1 is used; can use the column names of the analysis table as variables,  should be a logical or numerical value per gene (see Details)}

\item{as.table}{return a table}

\item{use.symbols}{return them as symbols (gene ids otherwise)}

\item{gene.info}{add gene infos to the output table}
}
\value{
a vector of gene names (or symbols), or a table
}
\description{
Return significant genes for this grandR object
}
\details{
The analysis parameter (just like for \link{GetAnalysisTable} can be a regex (that will be matched
against all available analysis names). It can also be a vector (of regexes). Be careful with this, if
more than one table e.g. with column LFC ends up in here, only the first is used (if criteria=LFC).

The criteria parameter can be used to define how analyses are performed. If criteria is a logical,
it obtains significant genes defined by cut-offs (e.g. on q value and LFC).
If it is a numerical, all genes are returned sorted (descendingly) by this value.
The columns of the given analysis table(s) can be used to build this expression.
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c(Design$Condition,Design$dur.4sU,Design$Replicate))
sars <- subset(sars,Coldata(sars,Design$dur.4sU)==2)
sars<-LFC(sars,mode="total",contrasts=GetContrasts(sars,contrast=c("Condition","Mock")))
GetSignificantGenes(sars,criteria=LFC>1)

}
\concept{diffexp}
