% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grand_manual.R
\name{grand_manual}
\alias{grand_manual}
\title{Manually add Guidelines for Reporting About Network Data (GRAND) information to an igraph object}
\usage{
grand_manual(
  G,
  name = NA,
  doi = NA,
  url = NA,
  vertex1 = NA,
  vertex2 = NA,
  positive = NA,
  negative = NA,
  weight = NA,
  level = NA,
  mode = NA,
  year = NA
)
}
\arguments{
\item{G}{An \link[igraph]{igraph} object, with weights/signs (if present) stored in \code{E(G)$weight}}

\item{name}{string: Name of the network (e.g., Zachary Karate Club)}

\item{doi}{string: DOI associated with the data (e.g., 10.1086/jar.33.4.3629752)}

\item{url}{string: Link to data (e.g., https://networks.skewed.de/net/karate)}

\item{vertex1}{string: Entity represented by nodes in a unipartite network, or by \code{FALSE} nodes in a bipartite network (e.g., people)}

\item{vertex2}{string: Entity represented by \code{TRUE} nodes in a bipartite network}

\item{positive}{string: Relationship represented by (positive) edges (e.g., friendship)}

\item{negative}{string: Relationship represented by negative edges, if present}

\item{weight}{string: What the edge weights represent (e.g., frequency, intensity, multiplexity)}

\item{level}{string: Scale on which edge weights are measured (e.g., continuous, count, ordinal, categorical)}

\item{mode}{string: Mode of data collection (e.g., survey, interview, sensor, observation, archival, simulation)}

\item{year}{numeric: Year in which data was collected (e.g., 1977)}
}
\value{
An \link[igraph]{igraph} object
}
\description{
The \code{grand_manual} function allows a user to manually and non-interactively add GRAND information to
an \link[igraph]{igraph} object. Normally this information should be added interactively using
\code{grand(mode = "interview")}.
}
\examples{
G <- igraph::make_graph("Zachary")  #An example network

G <- grand_manual(G,  #Manually enter information
     name = "Zachary Karate Club",
     doi = "10.1086/jar.33.4.3629752",
     url = "https://networks.skewed.de/net/karate",
     vertex1 = "People",
     positive = "Friendship",
     mode = "Observation",
     year = "1977")

grand(G, mode = "statement")  #Display summary statement

}
