% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNodes.R
\name{addNodes}
\alias{addNodes}
\title{Add nodes to graph.}
\usage{
addNodes(graph, n, generator, coordinates = NULL, by.centers = FALSE,
  skip.centers = integer(0L), par.fun = NULL, ...)
}
\arguments{
\item{graph}{[\code{\link{grapherator}}]\cr
Graph.}

\item{n}{[\code{integer}]\cr
Number of nodes to place. If \code{by.centers} is \code{FALSE} a single
integer value is expected. Otherwise, a vector \eqn{v} may be passed. In this case
\eqn{v[i]} coordinates are generated for each cluster. However, if a single value is
passed and \code{by.center == TRUE}, each cluster is assigned the same number of
nodes.}

\item{generator}{[\code{function(graph, ...)}]\cr
Function used to generate nodes. The functions needs to expect the number
of points to generate as the first argument \code{n}. Additional control argument are
possible.}

\item{coordinates}{[\code{matrix(n, 2)}]\cr
Matrix of coordinates (each row is one node/point).
Default is \code{NULL}. If this is set, setting of \code{generator}, \code{by.centers},
and \code{par.fun} are ignored. This parameter is handy, if one wants to add
coordinates by hand.
Default is \code{NULL}.}

\item{by.centers}{[\code{logical(1)}]\cr
Should coordinates be placed for each cluster center seperately? This enables
generation of clustered graphs.
Default is \code{FALSE}.}

\item{skip.centers}{[\code{integer}]\cr
Optional IDs of cluster centers not to consider in clustered node generation, i.e.,
if \code{by.centers = TRUE}.
Default is not to skip any cluster.}

\item{par.fun}{[\code{function(cc) | NULL}]\cr
Optional function which is applied to each cluster center before the generation
of coordinates in case \code{by.centers} is \code{TRUE}. This enables to specifically
determine additional parameters for the \code{generator} for each cluster.}

\item{...}{[any]\cr
Further arguments passed down to \code{generator}.}
}
\value{
[\code{\link{grapherator}}] Graph.
}
\description{
Places node coordinates in the two-dimensional Euclidean plane.
}
\examples{
# Clustered graph
g = graph(0, 1000)
g = addNodes(g, n = 5, generator = addNodesLHS)
g = addNodes(g, n = c(3, 10, 20, 10, 40), by.centers = TRUE, generator = addNodesUniform,
 lower = c(0, 0), upper = c(30, 30))
\dontrun{
plot(g, show.edges = FALSE)$pl.coords
}

# Mixed graph
g = graph(0, 100)
g = addNodes(g, n = 100, generator = addNodesLHS)
g = addNodes(g, n = 100, generator = addNodesGrid)

\dontrun{
plot(g, show.edges = FALSE)$pl.coords
}
}
\seealso{
Other graph generators: \code{\link{addEdges}},
  \code{\link{addWeights}}, \code{\link{graph}}
}
