% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_szgaViz.R
\name{szgaViz}
\alias{szgaViz}
\title{Sample size optimization using graphical approach in clinical trial design with two hypotheses}
\usage{
szgaViz(
  alpha,
  beta1,
  beta2,
  deltaVec,
  cVec,
  rho,
  wunit,
  initIntvl,
  visualization = TRUE
)
}
\arguments{
\item{alpha}{a value of overall type I error rate}

\item{beta1}{a value of one minus marginal powers for testing H1}

\item{beta2}{a value of one minus marginal powers for testing H2}

\item{deltaVec}{a vector of effect sizes for testing H1 nd H2, respectively}

\item{cVec}{a vector of coefficients. When testing continuous endpoints, these coefficients are exactly one. When testing binary endpoints, the values are roughly one but not exactly one}

\item{rho}{a value of correlation coefficients between two hypotheses}

\item{wunit}{a value of initial weight on H1 for grid search and visualization}

\item{initIntvl}{a vector of lower and upper limits for searching optimal sample size}

\item{visualization}{a logical value, indicating whether a visualization is needed}
}
\value{
a vector of three numbers: the optimal weight on H1 \code{w1}, and optimal sample size \code{n1} (based on H1) and \code{n2} (based on H2), where \code{n1} and \code{n2} should be roughly the same
}
\description{
This function computes the optimal design using graphical approach along with the minimum sample size when two hypotheses are considered in a clinical trial.
}
\examples{
szgaViz(alpha = 0.05, beta1 = 0.20, beta2 = 0.20,
         deltaVec = c(0.3,0.3), cVec = c(1,1), rho = 0.0,
         wunit= 0.01, initIntvl = c(1,1000),
         visualization = FALSE)

}
\references{
Zhang, F. and Gou, J. (2023). Sample size optimization for clinical trials using graphical approaches for multiplicity adjustment, Technical Report.
Gou, J. (2022). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. \emph{Biometrical Journal}, 64(2), 301-311.
}
\author{
Jiangtao Gou

Fengqing (Zoe) Zhang
}
