% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discard_unusable.R
\name{discard_unusable}
\alias{discard_unusable}
\title{Discard non-positive and/or non-finite observations in datasets}
\usage{
discard_unusable(data, columns)
}
\arguments{
\item{data}{(Type: data.frame) the dataset to be used.}

\item{columns}{The columns to be cleaned (e.g. \code{c("flow", "distw"))} in
the case of \code{ddm} when used with the example dataset \code{gravity_zeros})}
}
\value{
The function returns the summary of the estimated gravity model as an
\code{\link[stats]{lm}}-object.
}
\description{
\code{discard_unusable} drops observations that cannot be used
with models that convert columns to log scale, and therefore requiere non-negative
and finite observations.

Consider that some of the functions within this package will drop
observations when required and it is not requiered to be run before fitting a model.
}
\examples{
discard_unusable(gravity_zeros, "flow")
discard_unusable(gravity_zeros, c("flow", "distw"))
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[lmtest]{coeftest}},
\code{\link[sandwich]{vcovHC}}
}
