% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_dclbm.R
\docType{class}
\name{DcLbm}
\alias{DcLbm}
\alias{DcLbmPrior-class}
\alias{DcLbm-class}
\alias{DcLbmPrior}
\title{Degree Corrected Latent Block Model for bipartite graph class}
\usage{
DcLbmPrior(p = NaN)

DcLbm(alpha = 1, p = NaN)
}
\arguments{
\item{p}{Exponential prior parameter (default to Nan, in this case p will be estimated from data as the average intensities of X)}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{DcLbmPrior-class}

a \code{DcLbm-class} object
}
\description{
An S4 class to represent a degree corrected stochastic block model for co_clustering of bipartite graph.
Such model can be used to cluster graph vertex, and model a bipartite graph adjacency matrix \eqn{X} with the following generative model :
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i^r  \sim \mathcal{M}(1,\pi^r)}
\deqn{ Z_j^c  \sim \mathcal{M}(1,\pi^c)}
\deqn{ \theta_{kl} \sim Exponential(p)}
\deqn{ \gamma_i^r\sim \mathcal{U}(S_k)}
\deqn{ \gamma_i^c\sim \mathcal{U}(S_l)}
\deqn{ X_{ij}|Z_{ik}^cZ_{jl}^r=1 \sim \mathcal{P}(\gamma_i^r\theta_{kl}\gamma_j^c)}
The individuals parameters \eqn{\gamma_i^r,\gamma_j^c} allow to take into account the node degree heterogeneity.
These parameters have uniform priors over simplex \eqn{S_k}.
These classes mainly store the prior parameters value \eqn{\alpha,p} of this generative model.
The \code{DcLbm-class} must be used when fitting a simple Diagonal Gaussian Mixture Model whereas the \code{DcLbmPrior-class} must be sued when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
DcLbmPrior()
DcLbmPrior(p = 0.7)
DcLbm()
DcLbm(p = 0.7)
}
\seealso{
\code{\link{DcLbmFit-class}}, \code{\link{DcLbmPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
