% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessibility_greenspace.R
\name{accessibility_greenspace}
\alias{accessibility_greenspace}
\title{Generate Accessibility Map for Green Spaces and Export Data}
\usage{
accessibility_greenspace(
  green_area_data,
  location_lat,
  location_lon,
  max_walk_time = 15,
  green_color = "green",
  location_color = "blue",
  isochrone_color = "viridis",
  output_file = NULL
)
}
\arguments{
\item{green_area_data}{A list containing green area data, usually obtained from the \code{get_osm_data} function.}

\item{location_lat}{Numeric latitude of the specified location.}

\item{location_lon}{Numeric longitude of the specified location.}

\item{max_walk_time}{Maximum walking time in minutes. Default is 15.}

\item{green_color}{Color for the green areas on the map. Default is "green".}

\item{location_color}{Color for the specified location on the map. Default is "blue".}

\item{isochrone_color}{Color palette for the isochrone lines. Default is "viridis".}

\item{output_file}{Path and filename for the output geopackage. If NULL (default), no file is exported.}
}
\value{
A list containing a leaflet map object and the spatial data (sf objects).
}
\description{
This function generates a leaflet map that shows green spaces accessible within
a specified walking time from a given location. It also exports the spatial data
as a geopackage file for use in GIS software like QGIS.
}
\details{
Note: This function requires an OSRM server for isochrone computation. By default,
it uses the public OSRM API, which requires internet access. During CRAN checks
and non-interactive sessions, the function will halt to prevent unintended web requests.
}
\examples{
\dontrun{
  # First, get OSM data (this requires internet connection)
  osm_data <- get_osm_data("Lausanne, Switzerland")

  # Now use the green areas data in the accessibility function
  result <- accessibility_greenspace(
    green_area_data = osm_data$green_areas,
    location_lat = 46.5196,
    location_lon = 6.6322,
    output_file = tempfile(fileext = ".gpkg")
  )

  # View the leaflet map
  result$map

  # Check the structure of the returned data
  str(result, max.level = 1)
}
}
