% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_esa_wc}
\alias{get_esa_wc}
\title{Download landcover or NDVI Data from ESA WorldCover
10m Annual Dataset}
\usage{
get_esa_wc(
  bbox = NULL,
  place = NULL,
  datatype = "landcover",
  year = 2021,
  mask = TRUE,
  quiet = TRUE
)
}
\arguments{
\item{bbox}{\code{sf}, \code{sfc}, or a numeric vector (xmin, ymin, xmax, ymax)
defining the area of interest. Optional if \code{place} is provided.}

\item{place}{character or vector. (optional) A single line address,
e.g. ("1600 Pennsylvania Ave NW, Washington") or a vector of addresses
(c("Madrid", "Barcelona")).}

\item{datatype}{character. One of "landcover" and "ndvi".}

\item{year}{numeric. The year of interest: \code{2020} or \code{2021}. The default is \code{2021}.}

\item{mask}{logical (optional). Default is \code{TRUE}. If \code{TRUE}, masks the
raster data using the given \code{bbox} or \code{place}.}

\item{quiet}{logical. Whether show progress bars for some process.}
}
\value{
A \code{SpatRaster} object containing 11-class land cover or NDVI
yearly percentiles composite (NDVI p90, NDVI p50, NDVI p10)
}
\description{
download 11-class landcover or 3-band NDVI Data
(NDVI p90, NDVI p50, NDVI p10). Users can define an area of interest
using a bounding box or place name.
}
\examples{
result <- get_esa_wc(
  # place = 'New York'
  year = 2021
)

}
\references{
Zanaga, D., Van De Kerchove, R., De Keersmaecker, W., Souverijns, N.,
Brockmann, C., Quast, R., Wevers, J., Grosu, A., Paccini, A., Vergnaud, S.,
Cartus, O., Santoro, M., Fritz, S., Georgieva, I., Lesiv, M., Carter, S.,
Herold, M., Li, L., Tsendbazar, N.-E., … Arino, O. (2021).
ESA WorldCover 10 m 2020 v100 (Version v100).
Zenodo. https://doi.org/10.5281/zenodo.5571936

Zanaga, D., Van De Kerchove, R., Daems, D., De Keersmaecker, W., Brockmann,
C., Kirches, G., Wevers, J., Cartus, O., Santoro, M., Fritz, S., Lesiv, M.,
Herold, M., Tsendbazar, N.-E., Xu, P., Ramoino, F., & Arino, O. (2022).
ESA WorldCover 10 m 2021 v200 (Version v200).
Zenodo. https://doi.org/10.5281/zenodo.7254221
}
