% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_tools.R
\name{get_tree}
\alias{get_tree}
\title{Retrieve a single tree from a trained forest object.}
\usage{
get_tree(forest, index)
}
\arguments{
\item{forest}{The trained forest.}

\item{index}{The index of the tree to retrieve.}
}
\value{
A GRF tree object containing the below attributes.
    drawn_samples: a list of examples that were used in training the tree. This includes
    examples that were used in choosing splits, as well as the examples that populate the leaf
    nodes. Put another way, if honesty is enabled, this list includes both subsamples from the
    split (J1 and J2 in the notation of the paper).
    num_samples: the number of examples used in training the tree.
    nodes: a list of objects representing the nodes in the tree, starting with the root node. Each
    node will contain an 'is_leaf' attribute, which indicates whether it is an interior or leaf node.
    Interior nodes contain the attributes 'left_child' and 'right_child', which give the indices of
    their children in the list, as well as 'split_variable', and 'split_value', which describe the
    split that was chosen. Leaf nodes only have the attribute 'samples', which is a list of the
    training examples that the leaf contains. Note that if honesty is enabled, this list will only
    contain examples from the second subsample that was used to 'repopulate' the tree (J2 in the
    notation of the paper).
}
\description{
Retrieve a single tree from a trained forest object.
}
\examples{
\donttest{
# Train a quantile forest.
n <- 50
p <- 10
X <- matrix(rnorm(n * p), n, p)
Y <- X[, 1] * rnorm(n)
q.forest <- quantile_forest(X, Y, quantiles = c(0.1, 0.5, 0.9))

# Examine a particular tree.
q.tree <- get_tree(q.forest, 3)
q.tree$nodes
}

}
