% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grf_options.R
\name{grf_options}
\alias{grf_options}
\title{grf package options}
\usage{
grf_options()
}
\value{
Prints the current grf package options.
}
\description{
grf package options can be set using R's \code{\link{options}} command.
The current available options are:
\itemize{
\item `grf.verbose`: controls whether information is printed during training.
 The default value is `FALSE`.
 \item `grf.legacy.seed`: controls whether grf's random seed behavior depends on
 the number of CPU threads used to train the forest. The default value is `FALSE`.
 Set to `TRUE` to recover results produced with grf versions prior to 2.4.0.
}
}
\examples{
\donttest{
# Enable progress output during training.
options(grf.verbose = TRUE)
n <- 1500
p <- 10
X <- matrix(rnorm(n * p), n, p)
Y <- X[, 1] * rnorm(n)
r.forest <- regression_forest(X, Y)
options(grf.verbose = FALSE)

# Print current package options.
grf_options()

# Use random seed behavior prior to version 2.4.0.
options(grf.legacy.seed = TRUE)

# Use random seed independent of num.threads (default as of version 2.4.0 and higher).
options(grf.legacy.seed = FALSE)
}

}
