% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translater.R
\name{translater}
\alias{translater}
\title{'Groq': Translate Text}
\usage{
translater(text = NULL, toLanguage = "German", ...)
}
\arguments{
\item{text}{The text to be translated by 'Groq'. If not provided,
it will use what's copied on the clipboard.}

\item{toLanguage}{The language to be translated into.}

\item{...}{Following arguments can be set manually or in .Renviron:
\code{GROQ_API_KEY}is the 'Groq API' key.
\code{model} Model choice. Default is mistral-7b-instruct.
\code{systemRole} System role; Default is: "You are a helpful assistant
with extensive knowledge of R programming."
\code{maxTokens} The maximum integer of completion tokens returned.
\code{temperature} The amount of randomness in the response,
valued between 0 inclusive and 2 exclusive. Higher values are more
random, and lower values are more deterministic.
\code{top_p} Nucleus sampling threshold, valued between 0 and 1.
\code{proxy} Default value is NULL.}
}
\value{
A character value with the response generated by 'Groq'.
}
\description{
'Groq': Translate Text
}
\examples{
\dontrun{
translater("Dear Recipient, I hope this message finds you well.")
}

}
