% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_logistic.R
\name{grow_logistic}
\alias{grow_logistic}
\title{Logistic Growth Model}
\usage{
grow_logistic(time, parms)
}
\arguments{
\item{time}{vector of time steps (independent variable)}

\item{parms}{named parameter vector of the logistic growth model with:
\itemize{
  \item \code{y0} initial value of population measure
  \item \code{mumax} intrinsic growth rate (1/time)
  \item \code{K} carrying capacity (max. total concentration of cells)
}}
}
\value{
vector of dependent variable (\code{y}).
}
\description{
Classical logistic growth model written as analytical solution of the differential equation.
}
\details{
The equation used is:
\deqn{y = (K * y0) / (y0 + (K - y0) * exp(-mumax * time))}
}
\examples{

time <- seq(0, 30, length=200)
y    <- grow_logistic(time, c(y0=1, mumax=0.5, K=10))[,"y"]
plot(time, y, type="l")

}
\seealso{
Other growth models: 
\code{\link{grow_baranyi}()},
\code{\link{grow_exponential}()},
\code{\link{grow_gompertz}()},
\code{\link{grow_gompertz2}()},
\code{\link{grow_huang}()},
\code{\link{grow_richards}()},
\code{\link{growthmodel}},
\code{\link{ode_genlogistic}()},
\code{\link{ode_twostep}()}
}
\concept{growth models}
