% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomialPowerTable.R
\name{binomialPowerTable}
\alias{binomialPowerTable}
\title{Power Table for Binomial Tests}
\usage{
binomialPowerTable(
  pC = c(0.8, 0.9, 0.95),
  delta = seq(-0.05, 0.05, 0.025),
  n = 70,
  ratio = 1,
  alpha = 0.025,
  delta0 = 0,
  scale = "Difference",
  failureEndpoint = TRUE,
  simulation = FALSE,
  nsim = 1e+06,
  adj = 0,
  chisq = 0
)
}
\arguments{
\item{pC}{Vector of control group response rates.}

\item{delta}{Vector of treatment effects (differences in response rates).}

\item{n}{Total sample size.}

\item{ratio}{Ratio of experimental to control sample size.}

\item{alpha}{Type I error rate.}

\item{delta0}{Non-inferiority margin.}

\item{scale}{Scale for the test
(\code{"Difference"}, \code{"RR"}, or \code{"OR"}).}

\item{failureEndpoint}{Logical indicating if the endpoint is a
failure (\code{TRUE}) or success (\code{FALSE}).}

\item{simulation}{Logical indicating whether to use simulation (\code{TRUE})
or analytical (\code{FALSE}) power calculation.}

\item{nsim}{Number of simulations to run when \code{simulation = TRUE}.}

\item{adj}{Use continuity correction for the testing (default is 0;
only used if \code{simulation = TRUE}).}

\item{chisq}{Chi-squared value for the test (default is 0;
only used if \code{simulation = TRUE}).}
}
\value{
A data frame containing:
\describe{
  \item{\code{pC}}{Control group response or failure rate.}
  \item{\code{delta}}{Treatment effect.}
  \item{\code{pE}}{Experimental group response or failure rate.}
  \item{\code{Power}}{Power for the test (asymptotic or simulated).}
}
}
\description{
Creates a power table for binomial tests with various control group response rates and treatment effects.
The function can compute power and Type I error either analytically or through simulation.
With large simulations, the function is still fast and can produce exact power values to within
simulation error.
}
\details{
The function \code{binomialPowerTable()} creates a grid of all combinations of control group response rates and treatment effects.
All out of range values (i.e., where the experimental group response rate is not between 0 and 1) are filtered out.
For each combination, it computes the power either analytically using \code{nBinomial()} or through
simulation using \code{simBinomial()}.
When using simulation, the \code{simPowerBinomial()} function (not exported) is called
internally to perform the simulations.
Assuming \eqn{p} is the true probability of a positive test, the simulation standard error is
\deqn{\text{SE} = \sqrt{p(1 - p) / \text{nsim}}.}
For example, when approximating an underlying Type I error rate of 0.025, the simulation standard error is
0.000156 with 1000000 simulations and the approximated power 95% confidence interval
is 0.025 +/- 1.96 * SE = 0.025 +/- 0.000306.
}
\examples{
# Create a power table with analytical power calculation
power_table <- binomialPowerTable(
  pC = c(0.8, 0.9),
  delta = seq(-0.05, 0.05, 0.025),
  n = 70
)

# Create a power table with simulation
power_table_sim <- binomialPowerTable(
  pC = c(0.8, 0.9),
  delta = seq(-0.05, 0.05, 0.025),
  n = 70,
  simulation = TRUE,
  nsim = 10000
)
}
\seealso{
\code{\link{nBinomial}}, \code{\link{simBinomial}}
}
