% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_fwer_cont.R
\name{op_fwer_cont}
\alias{op_fwer_cont}
\title{Provides operating characteristics of group sequential MAMS trial for continuous outcome under null hypothesis}
\usage{
op_fwer_cont(alpha, beta, p, frac, delta0, delta1, nsim, seed)
}
\arguments{
\item{alpha}{numeric Type I error.}

\item{beta}{numeric Type II error.}

\item{p}{numeric Number of treatment arms.}

\item{frac}{numeric vector of fractions for information time at each look.}

\item{delta0}{numeric Standardized effect size in ineffective arm.}

\item{delta1}{numeric Standardized effect size in effective arm.}

\item{nsim}{numeric Number of simulations.}

\item{seed}{numeric Random seed number.}
}
\value{
A list of FWER, stage-wise type I error, average sample size used per arm, stopping probability, probability of futility.
}
\description{
Computes FWER and other characteristics for group-sequential MAMS trial for continuous outcome.
}
\examples{
op_fwer_cont(alpha=0.05, beta=0.1, p=2, frac=c(0.5, 1), delta0=0.178, delta1=0.545, nsim=15,seed=1)
}
