% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gscramble2newhybrids.R
\name{gscramble2newhybrids}
\alias{gscramble2newhybrids}
\title{Convert 'gscramble' output to newhybrids format}
\usage{
gscramble2newhybrids(
  M,
  M_meta,
  z = NULL,
  s = NULL,
  retain = NULL,
  outfile = tempfile()
)
}
\arguments{
\item{M}{the output from \code{segments2markers()} from 'gscramble'. This could
have an added \code{id} column on it, which will then be used for the
sample names.}

\item{M_meta}{the Marker meta data file.}

\item{z}{A vector of length two. The values
are regular expressions that the sample names that you want to have
-z 0 or -z 1 should match.  For example \code{c("SH", "CCT")} means any
sample matching "SH" would get z0 and any sample matchine "CCT" would
get z1.}

\item{s}{a single regular expressions that matches individuals that
should be given the -s option. For example "SH|CCT"}

\item{retain}{a vector of loci to retain.}

\item{outfile}{path to the file to write the newhybrids data set to. For CRAN
compliance, this is, by default, a temp file. But you can change it to be
anything valid.}
}
\value{
A list with three components:
\itemize{
\item \code{outfile}: outfile name of saved data.
\item \code{genos}: Genotypes
\item \code{allele_names}: Allele names.
}
}
\description{
This function turns character-based alleles into integers
and writes the necessary headers, etc.  It preferentially uses
the "id" column if it exists in \code{M$ret_ids}. Otherwise it uses
the \code{indiv} column for the sample names.
}
\details{
It allows you to set the -s and -z through some regular expression mapping.

This function relies a lot on some tidyverse functions
for pivoting, etc.  As such, it is not intended for data sets with
tens of thousands of markers.  You oughtn't be using NewHybrids with
so many markers, anyway!
}
\examples{
# get output from segments2markers():
example("segments2markers")
# copy that result to a new variable
M <- s2m_result

# then run it
gscramble2newhybrids(M, M_meta)
}
