% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_single_nucleus_gex.R
\name{get_single_nucleus_gex}
\alias{get_single_nucleus_gex}
\title{Get Single Nucleus Gex}
\usage{
get_single_nucleus_gex(
  gencodeIds,
  datasetId = "gtex_snrnaseq_pilot",
  tissueSiteDetailIds = NULL,
  excludeDataArray = TRUE,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{gencodeIds}{A character vector of Versioned GENCODE IDs, e.g.
c("ENSG00000132693.12", "ENSG00000203782.5").}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{excludeDataArray}{String. Options are TRUE or FALSE}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Retrieve Single Nucleus Gene Expression Data for a given Gene.

\href{https://gtexportal.org/api/v2/redoc#tag/Expression-Data-Endpoints/operation/get_single_nucleus_gex_api_v2_expression_singleNucleusGeneExpression_get}{GTEx Portal API documentation}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Search for one or more genes - returns a tibble with one row per tissue.
# Column "cellTypes" now contains a tibble of expression summary data, with
# one row for each cell type
get_single_nucleus_gex(gencodeIds = c(
  "ENSG00000203782.5",
  "ENSG00000132693.12"
))

# `excludeDataArray = FALSE` - expression values are stored under "celltypes"
# in an additional column called "data"
response <- get_single_nucleus_gex(
  gencodeIds = "ENSG00000132693.12",
  excludeDataArray = FALSE,
  itemsPerPage = 2
)

response

# "cellTypes" contains a tibble of data with one row for each
# cell type e.g. for Breast_Mammary_Tissue
response$cellTypes[[2]]

# when `excludeDataArray = FALSE`, expression values are stored in "data"
# e.g. for Breast_Mammary_Tissue, Epithelial cell (luminal):
response$cellTypes[[2]]$data[[1]]
\dontshow{\}) # examplesIf}
}
\seealso{
Other Expression Data Endpoints: 
\code{\link{get_clustered_median_exon_expression}()},
\code{\link{get_clustered_median_gene_expression}()},
\code{\link{get_clustered_median_junction_expression}()},
\code{\link{get_clustered_median_transcript_expression}()},
\code{\link{get_expression_pca}()},
\code{\link{get_gene_expression}()},
\code{\link{get_median_exon_expression}()},
\code{\link{get_median_gene_expression}()},
\code{\link{get_median_junction_expression}()},
\code{\link{get_median_transcript_expression}()},
\code{\link{get_single_nucleus_gex_summary}()},
\code{\link{get_top_expressed_genes}()}
}
\concept{Expression Data Endpoints}
