% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_duplicates.R
\name{remove_duplicates}
\alias{remove_duplicates}
\title{Remove duplicated entries}
\usage{
remove_duplicates(gtfs)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}
}
\value{
A GTFS object containing only unique entries.
}
\description{
Removes duplicated entries from GTFS objects tables.
}
\examples{
\dontshow{
  old_dt_threads <- data.table::setDTthreads(1)
  on.exit(data.table::setDTthreads(old_dt_threads), add = TRUE)
}
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

# this gtfs includes some duplicated entries
gtfs$agency

gtfs <- remove_duplicates(gtfs)
gtfs$agency

}
