% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_overall.R
\name{add_overall_tbl_ae}
\alias{add_overall_tbl_ae}
\alias{add_overall.tbl_ae}
\alias{add_overall.tbl_ae_count}
\alias{add_overall.tbl_ae_focus}
\title{Tabulate Overall Summary}
\usage{
\method{add_overall}{tbl_ae}(x, across = NULL, ...)

\method{add_overall}{tbl_ae_count}(x, across = NULL, ...)

\method{add_overall}{tbl_ae_focus}(x, across = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{"tbl_ae"}, \code{"tbl_ae_focus"}, or \code{"tbl_ae_count"}}

\item{across}{Specify the type of overall statistics to include.
\itemize{
\item \code{"both"} adds summaries across both the \verb{by=} and \verb{strata=} levels
\item \code{"by"} adds summaries across the \verb{by=} levels
\item \code{"strata"} adds summaries across the \verb{strata=} levels
\item \code{"overall-only"} adds a single overall column
Default is all possible overall types.
}}

\item{...}{Not used}
}
\value{
Summary object of same input class
}
\description{
Tabulate Overall Summary
}
\section{Notes}{

If the spanning headers are modified prior to the call of \code{add_overall()},
the ordering of the columns may not be correct.
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_overall_ex1.png}{options: style="width: 100\%;"}}

\if{html}{Example 2}

\if{html}{\figure{add_overall_ex2.png}{options: style="width: 70\%;"}}

\if{html}{Example 3}

\if{html}{\figure{add_overall_ex3.png}{options: style="width: 90\%;"}}

\if{html}{Example 4}

\if{html}{\figure{add_overall_ex4.png}{options: style="width: 90\%;"}}
}

\examples{
\donttest{
# Example 1 -----------------------------------------------------------------
add_overall_ex1 <-
  df_adverse_events \%>\%
  tbl_ae_count(
    ae = adverse_event,
    soc = system_organ_class,
    by = grade,
    strata = trt
  ) \%>\%
  add_overall() \%>\%
  modify_header(all_ae_cols() ~ "**Grade {by}**") \%>\%
  bold_labels()

# Example 2 -----------------------------------------------------------------
add_overall_ex2 <-
  df_adverse_events \%>\%
  tbl_ae(
    id = patient_id,
    ae = adverse_event,
    soc = system_organ_class,
    by = grade
  ) \%>\%
  add_overall(across = 'by') \%>\%
  modify_header(all_ae_cols() ~ "**Grade {by}**") \%>\%
  bold_labels()

# Example 3 -----------------------------------------------------------------
add_overall_ex3 <-
  df_adverse_events \%>\%
  tbl_ae_focus(
    id = patient_id,
    include = c(any_complication, grade3_complication),
    ae = adverse_event,
    strata = trt
  ) \%>\%
  add_overall(across = 'strata')

# Example 4 -----------------------------------------------------------------
add_overall_ex4 <-
  df_adverse_events \%>\%
  tbl_ae(
    id = patient_id,
    ae = adverse_event,
    soc = system_organ_class,
    by = grade,
    strata = trt
  ) \%>\%
  add_overall(across = 'overall-only') \%>\%
  modify_header(all_ae_cols() ~ "**Grade {by}**") \%>\%
  bold_labels()
}
}
