% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uni_reg.R
\name{uni_reg}
\alias{uni_reg}
\title{Univariate regression (Odds, Risk, or Rate Ratios)}
\usage{
uni_reg(data, outcome, exposures, approach = "logit")
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{outcome}{outcome variable (binary, continuous, or count).}

\item{exposures}{A vector of predictor variables.}

\item{approach}{Modeling approach to use. One of:
`"logit"` (OR), `"log-binomial"` (RR), `"poisson"` (IRR),
`"robpoisson"` (RR), `"linear"` (Beta coefficients), `"negbin"` (IRR)}
}
\value{
A list of class `uni_reg` and `gtsummary::tbl_stack`, including:
\itemize{
  \item A publication-ready regression table (`tbl_stack`)
  \item Accessor elements:
    \itemize{
      \item `$models`: Fitted regression models for each exposure
      \item `$model_summaries`: Tidy model summaries
      \item `$reg_check`: Diagnostics (only for linear regression)
    }
}
}
\description{
Performs univariate regression for each exposure on a binary,
continuous, or count outcome.
Depending on `approach`, returns either Odds Ratios (OR), Risk Ratios (RR),
or Incidence Rate Ratios (IRR).
}
\details{
This function requires the following packages:
`dplyr`, `purrr`, `gtsummary`, `risks`.
}
\examples{
data(PimaIndiansDiabetes2, package = "mlbench")
library(dplyr)
pima <- PimaIndiansDiabetes2 |>
  dplyr::mutate(diabetes = ifelse(diabetes == "pos", 1, 0))
uni_reg(pima, outcome = "diabetes", exposures = "age", approach = "logit")
}
\seealso{
\code{\link{multi_reg}}, \code{\link{plot_reg}}
}
\concept{regression functions}
