% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_regression.R
\name{tbl_regression}
\alias{tbl_regression}
\alias{tbl_regression.default}
\title{Regression model summary}
\usage{
tbl_regression(x, ...)

\method{tbl_regression}{default}(
  x,
  label = NULL,
  exponentiate = FALSE,
  include = everything(),
  show_single_row = NULL,
  conf.level = 0.95,
  intercept = FALSE,
  estimate_fun = ifelse(exponentiate, label_style_ratio(), label_style_sigfig()),
  pvalue_fun = label_style_pvalue(digits = 1),
  tidy_fun = broom.helpers::tidy_with_broom_or_parameters,
  add_estimate_to_reference_rows = FALSE,
  conf.int = TRUE,
  ...
)
}
\arguments{
\item{x}{(regression model)\cr
Regression model object}

\item{...}{Additional arguments passed to \code{\link[broom.helpers:tidy_plus_plus]{broom.helpers::tidy_plus_plus()}}.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to change variables labels, e.g. \code{list(age = "Age", stage = "Path T Stage")}}

\item{exponentiate}{(scalar \code{logical})\cr
Logical indicating whether to exponentiate the coefficient estimates.
Default is \code{FALSE}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{show_single_row}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
By default categorical variables are printed on multiple rows.
If a variable is dichotomous (e.g. Yes/No) and you wish to print the
regression coefficient on a single row, include the variable name(s) here.}

\item{conf.level}{(scalar \code{real})\cr
Confidence level for confidence interval/credible interval. Defaults to \code{0.95}.}

\item{intercept}{(scalar \code{logical})\cr
Indicates whether to include the intercept in the output.  Default is \code{FALSE}}

\item{estimate_fun}{(\code{function})\cr
Function to round and format coefficient estimates.
Default is \code{\link[=label_style_sigfig]{label_style_sigfig()}} when the coefficients are not transformed, and
\code{\link[=label_style_ratio]{label_style_ratio()}} when the coefficients have been exponentiated.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{\link[=label_style_pvalue]{label_style_pvalue()}}.}

\item{tidy_fun}{(\code{function})\cr
Tidier function for the model. Default is to use \code{broom::tidy()}.
If an error occurs, the tidying of the model is attempted with
\code{parameters::model_parameters()}, if installed.}

\item{add_estimate_to_reference_rows}{(scalar \code{logical})\cr
Add a reference value. Default is \code{FALSE}.}

\item{conf.int}{(scalar \code{logical})\cr
Logical indicating whether or not to include a confidence
interval in the output. Default is \code{TRUE}.}
}
\value{
A \code{tbl_regression} object
}
\description{
This function takes a regression model object and returns a formatted table
that is publication-ready. The function is customizable
allowing the user to create bespoke regression model summary tables.
Review the
\href{https://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html}{\code{tbl_regression()} vignette}
for detailed examples.
}
\section{Methods}{


The default method for \code{tbl_regression()} model summary uses \code{broom::tidy(x)}
to perform the initial tidying of the model object. There are, however,
a few models that use \link[=tbl_regression_methods]{modifications}.
\itemize{
\item \code{"parsnip/workflows"}: If the model was prepared using parsnip/workflows,
the original model fit is extracted and the original \verb{x=} argument
is replaced with the model fit. This will typically go unnoticed; however,if you've
provided a custom tidier in \verb{tidy_fun=} the tidier will be applied to the model
fit object and not the parsnip/workflows object.
\item \code{"survreg"}: The scale parameter is removed, \code{broom::tidy(x) \%>\% dplyr::filter(term != "Log(scale)")}
\item \code{"multinom"}: This multinomial outcome is complex, with one line per covariate per outcome (less the reference group)
\item \code{"gam"}: Uses the internal tidier \code{tidy_gam()} to print both parametric and smooth terms.
\item \code{"lmerMod"}, \code{"glmerMod"}, \code{"glmmTMB"}, \code{"glmmadmb"}, \code{"stanreg"}, \code{"brmsfit"}: These mixed effects
models use \code{broom.mixed::tidy(x, effects = "fixed")}. Specify \code{tidy_fun = broom.mixed::tidy}
to print the random components.
}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "broom.helpers"))) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
glm(response ~ age + grade, trial, family = binomial()) |>
  tbl_regression(exponentiate = TRUE)
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
