% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{normalise_obj}
\alias{normalise_obj}
\title{Normalise a JSON-list.}
\usage{
normalise_obj(obj, resource_url)
}
\arguments{
\item{obj}{A JSON-list. This is just an ordinary list as returned by
\code{\link{gc_request}} or \code{\link{gc_request_all}}.}

\item{resource_url}{The URL endpoint used to obtain the JSON-list \code{obj}.
This is used to infer the type of GWAS entity returned. See
\code{\link{object_type_from_url}} for more details.}
}
\value{
A normalised JSON-list.
}
\description{
This function normalises a JSON-list. The concept of JSON-list is here
defined as an ordinary R list object whose elements are either all named or
none is named. These lists map naturally to JSON elements: objects and
arrays. What this function does is wrap certain elements of the nested
list \code{obj} in \code{list()} to make the tree structure of the \code{obj}
list homologous across different responses. This makes all responses of the
same entity type (studies, associations, variants or traits) homologous and
hence joinable with family functions \code{lst_*_join}.
}
\details{
This normalisation is GWAS object type specific. The parameter
\code{resource_url} should be mappable to either studies, associations,
variants or traits by \code{\link{object_type_from_url}}.
}
\keyword{internal}
