% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{cell_to_point}
\alias{cell_to_point}
\title{Convert H3 cell index to point location}
\usage{
cell_to_point(h3_address = NULL, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, an \code{sfc_POINT} object of \code{length(h3_address)}.
  EPSG:WGS84.
}
\description{
This function takes a H3 cell index and returns its center coordinates in
WGS84.
}
\examples{
# Where is the center of the hexagon over the Brisbane Town Hall at resolution 10?
brisbane_10 <- cell_to_point(h3_address = '8abe8d12acaffff')

}
