#' @encoding UTF-8
#' @keywords internal
"_PACKAGE"

#' @noRd
structure.fun <- function(design) {
  design.colnames <- colnames(design)
  novar <- length(colnames(design))
  effects.table <- matrix(" ",nrow=novar,ncol=novar)
  rownames(effects.table)<- design.colnames
  colnames(effects.table)<- design.colnames
  for (r.effect in 2:novar) effects.table[r.effect,1] <- 1  #Setting entries for mean column
  for (c.effect in 2:novar) effects.table[1,c.effect] <- 0  #Setting entries for mean row           
  for (r.effect in 2:novar) {
    for (c.effect in 2:novar) {
      if (r.effect != c.effect) {
        freq.table <- table(design[ ,r.effect],design[ ,c.effect])
        # freq.table contains number of times mth value of factor alpha occurs with kth value of factor betai
        # First condition checks whether there is a combination of alphath factor and kth value of betaith factor
        # which has a freq of 0 i.e. doesn't occur
        # If first condition is satisfied then table(freq.table[ ,k])[1] is number of times 0 occurs
        # Second condition checks whether all but one row has a value 0 for kth value of betaith factor
        # If both conditions are satisfied then the kth value of betaith factor is nested within alphath factor
        nestk <- rep(0, length=nrow(freq.table))   #Set up factor for all k levels of factorj to indicate whether nested within factor i
        for (k in 1:nrow(freq.table)) {
          if (min(freq.table[k,])==0 && table(freq.table[k, ])[1]+1==ncol(freq.table)) { 
            nestk[k] <- 1 
          } else {
            if (min(freq.table[k, ])==0) {
              nestk[k] <- 0.5 
            } else {
              nestk[k] <- 0
            }
          }
        }
        effects.table[r.effect,c.effect] <- if (all(nestk==1)) "1" else if (all(nestk==0)) "0" else "(0)"
      }
    }
  }
  effects.table
}

#' @noRd
extract.factor.fun <- function(effect) {
  pos_<-gregexpr("\\^",effect)
  posbo<-gregexpr("\\(",effect)
  posbc<-gregexpr("\\)",effect)
  posi_ <- -1
  #This loop finds position of ^ which separate effects but are not contained within a nested effect
  for (k in 1:length(pos_[[1]])) {
    if (length(posbo[[1]][posbo[[1]]< pos_[[1]][k]]) == length(posbc[[1]][posbc[[1]]< pos_[[1]][k]])) {
      posi_ <- c(posi_,pos_[[1]][k])
    }
  }
  if (length(posi_)>1) posi_ <- posi_[-1]
  if (posi_[1] ==-1) {
    vec.factor<- effect
  } else {
    no.factors <- 1+length(posi_)
    vec.factor <- rep("",no.factors)
    if (no.factors==2) {
      vec.factor[1] <- substring(effect,1,posi_[1]-1)
      vec.factor[2] <- substring(effect,posi_[1]+1,nchar(effect))
    } else {
      for (i in 1:(no.factors-2)) {
        if (i==1) vec.factor[1] <- substring(effect,1,posi_[i]-1)
        vec.factor[i+1] <- substring(effect,posi_[i]+1,posi_[i+1]-1)
        if (i==(no.factors-2)) vec.factor[i+2] <- substring(effect,posi_[i+1]+1,nchar(effect))
      }
    }
    vec.factor
  }
}

#' @noRd
extract.nestfactor.fun <- function(effect) {
  posbo<-gregexpr("\\(",effect)[[1]]      #opening brackets
  posbc<-gregexpr("\\)",effect)[[1]]      #closing brackets      
  if (posbo[1] == -1) {
    vec.factor<- effect
  } else {    
    posbci.lt <- posbc[c((posbc[-length(posbc)]<posbo[-1]),T)]
    posboi.lt <- posbo[c(T,(posbc[-length(posbc)]<posbo[-1]))]
    vec.factor <- substring(effect,1,posboi.lt[1]-1)    #Includes effect up to first opening bracket
    if (length(posbci.lt)>1) {
      for (lt in 1:(length(posbci.lt)-1)) {
        vec.factor <- paste(vec.factor,substring(effect,posbci.lt[lt]+1,posboi.lt[lt+1]-1),sep="")  #Includes effect after closed bracket corresponding first opening bracket up to next opneing bracket    
      }
    }
    if (posbci.lt[length(posbci.lt)] != nchar(effect)) {
      vec.factor <- paste(vec.factor,substring(effect,posbci.lt[length(posbci.lt)]+1,nchar(effect)),sep="")
    }
  }
  vec.factor
}

#' @noRd
brief.effect.fun <- function(effect, abbrev.length) {
  pos_<-gregexpr("\\^",effect)[[1]]
  if (pos_[1] ==-1) {
    brief.effect<- effect
  } else {
    no.factors <- 1+length(pos_)
    if (no.factors==2) {
      brief.effect <- paste(substring(effect,1,min(pos_[1]-1,abbrev.length[substring(effect,1,pos_[1]-1)])),"^",substring(effect,pos_[1]+1,min(pos_[1]+abbrev.length[substring(effect,pos_[1]+1,nchar(effect))],nchar(effect))),sep="")
    } else {
      for (i in 1:(no.factors-2)) {
        if (i==1) brief.effect <- substring(effect,1,min(pos_[1]-1,abbrev.length[substring(effect,1,pos_[1]-1)]))
        brief.effect <- paste(brief.effect,"^",substring(effect,pos_[i]+1,min(pos_[i]+abbrev.length[substring(effect,pos_[i]+1,pos_[i+1]-1)],pos_[i+1]-1)),sep="")
        if (i==(no.factors-2)) brief.effect <- paste(brief.effect,"^",substring(effect,pos_[i+1]+1,min(pos_[i+1]+abbrev.length[substring(effect,pos_[i+1]+1,nchar(effect))],nchar(effect))),sep="") 
      }
    }
  }
  brief.effect
}     


#' @noRd
sortaov.term.fun <- function(x, noall) {
  splitmatrixformat <- suppressWarnings(do.call(rbind, strsplit(x, ":")))
  sort.splitmatrix <- t(apply(as.matrix(splitmatrixformat),1,sort))
  sorted.effects <- matrix(NA, nrow=dim(sort.splitmatrix)[1], ncol=dim(sort.splitmatrix)[2] )
  for (k in 1:dim(sort.splitmatrix)[1] ) {
    for (j in 1:length(unique(sort.splitmatrix[k, ]) )) {
      sorted.effects[k,j] <- unique(sort.splitmatrix[k, ])[j]
    }
  }
  sortedx <- rep("",length(x))
  for (k in 1:length(x)) {
    for (j in 1:dim(sorted.effects)[2]) {
      if (j==1) sortedx[k] <- paste(sorted.effects[k,j])
      if (j>1 && sortedx[k]!="" && !is.na(sorted.effects[k,j])) sortedx[k] <- paste(sortedx[k],":",sorted.effects[k,j],sep="")
    }
  }
  sortedx     
}


#' @noRd
confound.tab.fun <- function(no.confounded, noall, all.nestedin.conf.table, conf.nestedin.all.table,
                             confounded.main, outputlistip1) {
  confound.main <- "" 
  confound.effect <- "" 
  if (no.confounded > 0) {
    for (confoundi in 1:no.confounded) {
      for (effectalli in 1:noall) {
        if (all.nestedin.conf.table[effectalli,confoundi]=="1" & conf.nestedin.all.table[confoundi,effectalli]=="1") {
          confound.main <- c(confound.main,confounded.main[confoundi])
          confound.effect <- c(confound.effect,colnames(outputlistip1$designi)[effectalli])
        }
      }
    }
  }
  confound.tab <- cbind(confound.main[-1],confound.effect[-1])
}

confound.print.fun <- function(confound.tab) {
  if (nrow(confound.tab) > 0) {
    for (confoundi in 1:nrow(confound.tab)) {
      cat("\nEffect ",confound.tab[confoundi,1]," is confounded with ",confound.tab[confoundi,2])
    }
  }
}


#' @noRd
designorder <- function (level, orderdsi, designi_1, order.effectsi_1, level.order.objectsi_1, 
                         keep.nested.objectsi_1, keep.nested.interactionsi_1, keep.order.objectsiuniqi_1, 
                         main.effects.table.nestintnames, main.effects.table, prelim.effect.order, 
                         maxfacs, datadesign) {
  
  #Add interactions
  #putting all interactions between effects of order i-1 into order.effectsi
  order.effectsi <- ""
  keep.order.objectsiuniqi <- ""
  if (length(order.effectsi_1)>1) {
    for (i in 1:length(order.effectsi_1)) {
      for (j in 1:length(order.effectsi_1)) {
        if (j > i) {
          int.name <- paste(order.effectsi_1[i],"^",order.effectsi_1[j],sep="")
          if (length(order.effectsi) > 1 || order.effectsi !="") {               
            order.effectsi <- c(order.effectsi,int.name)
          } else {
            order.effectsi <- int.name
          }
        }
      }
    }
  }
  if (length(keep.nested.objectsi_1) >1 || keep.nested.objectsi_1 != "") {
    if (length(order.effectsi) > 1 || order.effectsi !="") {
      order.effectsi <- c(order.effectsi,keep.nested.objectsi_1)
    } else {
      order.effectsi <- keep.nested.objectsi_1
    }
  }
  if (length(keep.nested.interactionsi_1) >1 || keep.nested.interactionsi_1 != "") {
    if (length(order.effectsi) > 1 || order.effectsi !="") {
      order.effectsi <- c(order.effectsi,keep.nested.interactionsi_1)
    } else {
      order.effectsi <- keep.nested.interactionsi_1
    }
  } 
  if (length(keep.order.objectsiuniqi_1) >1 || keep.order.objectsiuniqi_1 != "") {
    if (length(order.effectsi) > 1 || order.effectsi !="") {
      order.effectsi <- c(order.effectsi,keep.order.objectsiuniqi_1)
    } else {
      order.effectsi <- keep.order.objectsiuniqi_1
    }
  } 
  
  #-----------------------------------------------------------------------------------------------------------
  #Eliminating terms in order.effectsi which are repeats
  # First split terms into their components and eliminate repeats
  if (length(order.effectsi) >1 || order.effectsi != "") {
    factor.effectsi <- array("",dim=c(length(order.effectsi),maxfacs))
    for (k in 1:length(order.effectsi))  {
      factor.veci <- sort(unique(extract.factor.fun(order.effectsi[k])))
      factor.veci <- c(factor.veci,rep("",(maxfacs-length(factor.veci))))
      factor.effectsi[k, ] <- factor.veci
    }
    factor.effectsiuniq <- unique(factor.effectsi)
    
    #This now sorts factor.effectsiuniq so that effects with less terms come first - needed for nested algorithm
    for (j in 1: ncol(factor.effectsiuniq)) {
      factor.effectsiuniq<-rbind(factor.effectsiuniq[factor.effectsiuniq[ ,j]=="", ],factor.effectsiuniq[factor.effectsiuniq[ ,j]!="", ])
    }
    now.factor.effectsiuniq <- factor.effectsiuniq
    keep.factor.effectsiuniq <- factor.effectsiuniq
    #This restricts interactions to those with number of terms of level or less e.g. at level 4 interactions involve no more than 4 terms  
    now.factor.effectsiuniq<-now.factor.effectsiuniq[now.factor.effectsiuniq[ ,eval(level+1)]=="", ,drop=F]
    keep.factor.effectsiuniq<-keep.factor.effectsiuniq[keep.factor.effectsiuniq[ ,eval(level+1)]!="", ,drop=F]
    
    # Then merge components to give model interaction terms to be included at this level
    for (i in 1:nrow(now.factor.effectsiuniq)) {
      for (j in 1:maxfacs)  {
        if (now.factor.effectsiuniq[i,j] !="") {
          if (j==1) {
            int.val <- paste(datadesign[ ,paste(now.factor.effectsiuniq[i,j])],sep="")
            int.name <- now.factor.effectsiuniq[i,j]
          } else {
            int.val <- paste(int.val,"_",datadesign[ ,paste(now.factor.effectsiuniq[i,j])],sep="")
            int.name <- paste(int.name,"^",now.factor.effectsiuniq[i,j],sep="")
          }
        }
      }
      if (i==1) {
        designiints <- array(int.val,dim=c(length(int.val),1))
        order.effectsiuniq <- int.name
      } else {
        designiints <- cbind(designiints,int.val)
        order.effectsiuniq <- c(order.effectsiuniq,int.name)
      }
    }
    colnames(designiints)<- order.effectsiuniq
    # Then merge components to give model interaction terms to be included at lower levels
    
    if (nrow(keep.factor.effectsiuniq)>0) {
      for (i in 1:nrow(keep.factor.effectsiuniq)) {
        for (j in 1:maxfacs) {
          if (keep.factor.effectsiuniq[i,j] !="")  {
            if (j==1) {
              int.name <- keep.factor.effectsiuniq[i,j]
            } else {
              int.name <- paste(int.name,"^",keep.factor.effectsiuniq[i,j],sep="")
            }
          }
        }
        if (i==1) {
          keep.order.effectsiuniq <- int.name
        } else {
          keep.order.effectsiuniq <- c(keep.order.effectsiuniq,int.name)
        }
      }
      if (length(keep.order.effectsiuniq)>1) {
        keep.order.objectsiuniqi <- unique(keep.order.effectsiuniq) #Not sure about this bit
      } else {
        keep.order.objectsiuniqi <- ""
      }
    }
  }
  
  #Next look for effects identified in preliminary effects order as level i
  order.effectsxint <- main.effects.table.nestintnames[prelim.effect.order==orderdsi]
  order.effectsx <-rownames(main.effects.table)[prelim.effect.order==orderdsi]
  
  if (length(order.effectsx)>0) {
    designi <- cbind(designi_1,datadesign[ ,paste(order.effectsx)])
    colnames(designi) <- c(colnames(designi_1),order.effectsxint) 
  } else {
    designi<-designi_1                       
  }
  
  if (length(order.effectsi) >1 || order.effectsi != "") designi <- cbind(designi,designiints)
  
  effects.table.orderi <- structure.fun(designi)
  
  #-----------------------------------------------------------------------------------------------------------
  #Remove any effects which are confounded
  rm.effect <- 0
  no.effectsi <- length(colnames(effects.table.orderi))
  for (i in 1:(no.effectsi-1)) {
    for (j in (i+1):no.effectsi) {
      if (effects.table.orderi[i,j]=="1" & effects.table.orderi[j,i]=="1") rm.effect <- c(rm.effect,j)
    }
  }
  
  if (length(rm.effect)>1) {
    rm.effects <- unique(rm.effect[-1])
    designi <- designi[ ,-rm.effects]
    effects.table.orderi <- effects.table.orderi[-rm.effects,-rm.effects]
  }
  
  order.effects <-  colnames(designi)
  level.order.objectsi <- c(level.order.objectsi_1,rep(orderdsi,(length(colnames(designi))-length(level.order.objectsi_1))))
  
  rm.nested.effect <- 0
  keepa.nested.effect <- ""
  keep.nested.interaction <- ""
  no.effectsi <- length(colnames(effects.table.orderi))
  for (i in 1:(no.effectsi-1)) {
    for (j in (i+1):no.effectsi) {
      keep.nested.effectk <- ""
      if (level.order.objectsi[i] <= level.order.objectsi[j]) {
        i.factors <- extract.factor.fun(colnames(effects.table.orderi)[i])
        j.factors <- extract.factor.fun(colnames(effects.table.orderi)[j])
        if ((all(i.factors %in% j.factors))& (level.order.objectsi[i] != level.order.objectsi[j])) {
          ignore <- "y" 
        } else {
          ignore <- "n"
        }
        if (ignore=="n" & effects.table.orderi[i,j]=="(0)" & effects.table.orderi[j,i]=="1" & (length(i.factors)>1 | length(j.factors)>1)) {
          rm.nested.effect <- c(rm.nested.effect,j)  #Keeping col numbers of effects to be removed at this level
          
          #Keeping note of effects to be incorporated lower down
          if ((all(i.factors %in% j.factors)) & (level.order.objectsi[i] == level.order.objectsi[j]))  {
            keep.nested.interaction <- c(keep.nested.interaction,colnames(effects.table.orderi)[j])   #Keeping name of interaction effect which needs moving to a lower level
          } else {
            #Keeping name of interaction effect which needs moving to a lower level
            keep.nested.factors <- unique(c(i.factors,j.factors))
            for (k in 1:length(keep.nested.factors)) {
              if (k==1) {
                keep.nested.effectk <- keep.nested.factors[k]
              } else {
                keep.nested.effectk <- paste(keep.nested.effectk,"^",keep.nested.factors[k],sep="")
              }
            }
            keepa.nested.effect <- c(keepa.nested.effect,keep.nested.effectk)
          }
        }
      }
    }
  }
  
  #-----------------------------------------------------------------------------------------------------------
  
  if (length(rm.nested.effect)>1) {
    rm.nested.effects <- unique(rm.nested.effect[-1])
    designi <- designi[ ,-rm.nested.effects]
    effects.table.orderi <- effects.table.orderi[-rm.nested.effects,-rm.nested.effects]
  }
  
  if (length(keepa.nested.effect)>1) {
    keepa.nested.effects <- unique(keepa.nested.effect[-1])
  }
  
  if (length(keep.nested.interaction)>1) {
    keep.nested.interactionsi <- unique(keep.nested.interaction[-1])
  } else {
    keep.nested.interactionsi <- ""
  }
  
  if (length(keepa.nested.effect)>1) {
    factor.nested.effectsi <- array("",dim=c(length(keepa.nested.effects),maxfacs))
    for (k in 1:length(keepa.nested.effects)) {
      nested.veci <- sort(unique(extract.factor.fun(keepa.nested.effects[k])))
      nested.veci <- c(nested.veci,rep("",(maxfacs-length(nested.veci))))
      factor.nested.effectsi[k, ] <- nested.veci
    }
    nested.effectsiuniq <- unique(factor.nested.effectsi)
    order.nested.effectsiuniq <- ""
    
    # Then merge components to give model interaction terms
    for (i in 1:nrow(nested.effectsiuniq)) {
      for (j in 1:maxfacs)  {
        if (nested.effectsiuniq[i,j] !="") {
          if (j==1) {  
            int.name <- nested.effectsiuniq[i,j]  
          } else { 
            int.name <- paste(int.name,"^",nested.effectsiuniq[i,j],sep="") 
          }
        }
      }
      if (i==1) {  
        order.nested.effectsiuniq <- int.name
      } else {
        order.nested.effectsiuniq <- c(order.nested.effectsiuniq,int.name)
      }
    }
    keep.nested.objectsi<- order.nested.effectsiuniq
    
  } else {
    keep.nested.objectsi <- ""
  }
  
  #-----------------------------------------------------------------------------------------------------------
  order.effects <-  colnames(designi)
  level.order.objectsi <- c(level.order.objectsi_1,rep(orderdsi,(length(colnames(designi))-length(level.order.objectsi_1))))
  order.effectsi <- order.effects[level.order.objectsi==orderdsi]
  # outputlist <- list(designi, order.effectsi, level.order.objectsi)
  outputlist <- list(designi=designi,level.order.objectsi=level.order.objectsi)
  outputlist$keep.nested.objectsi <- keep.nested.objectsi
  outputlist$keep.nested.interactionsi <- keep.nested.interactionsi
  outputlist$keep.order.objectsiuniqi <- keep.order.objectsiuniqi
  outputlist
}

#' @noRd
model.effects.fun <- function (x) {
  #The function assumes the first term is the mean which is removed
  model.effects.facfn <- x[-1]
  for (i in 1:length(model.effects.facfn)) {
    model.effects.facfn[i] <- gsub("\\^",":",model.effects.facfn[i])
    model.effects.facfn[i] <- gsub("\\(",":",model.effects.facfn[i])
    model.effects.facfn[i] <- gsub("\\)","",model.effects.facfn[i])
    model.effects.facfn[i] <- gsub("\\:","\\):as.factor\\(",model.effects.facfn[i])
    model.effects.facfn[i] <- paste(" as.factor(", model.effects.facfn[i],")", sep="")
  }
  model.effects.facfn
}

#' @noRd
model.equation.fun <- function (x) {
  #creating the equation together with dummy response
  model.equation <- paste("DummyResponse ~ ", x[1],sep=" ")
  if(length(x)>1) {
    for (i in 2:(length(x))) model.equation<- paste(model.equation , x[i] , sep=" + ")
  }
  model.equation
}


#' @noRd
model.rhsequation.fun <- function (x) {
  #creating the equation without dummy response
  model.rhsequation <- paste("~ ", x[1],sep=" ")
  if(length(x)>1) {
    for (i in 2:(length(x))) model.rhsequation<- paste(model.rhsequation , x[i] , sep=" + ")
  }
  model.rhsequation
}


#' @noRd
strip.order.fun <- function (x) {
  x <- gsub(" ","",x)
  x <- gsub("as.factor\\(","",x)
  x <- gsub("\\)","",x)
  x
}


#' @noRd
strip.order.biglm.fun <- function (x) {
  x <- gsub(" ","",x)
  x <- gsub("as.factor","",x)
  x <- gsub("\\(","",x)
  x <- gsub("\\:","\\^",x)
  x <- gsub("\\)","",x)
  x <- gsub("Intercept","Mean",x)
  x <- gsub("[0123456789]","",x)
  x
}


#' @noRd
sort_effectorder_fun <- function(x) {
  splitmatrixformat <- suppressWarnings(do.call(rbind, strsplit(x, "\\^")))
  sorted.effects <- apply(t(apply(as.matrix(splitmatrixformat),1,sort)),1,unique)
  sortedx <- rep("",length(x))
  for (k in 1:length(x)) {
    for (i in 1:length(sorted.effects[[k]]))  {
      if (i==1) sortedx[k] <- paste(sorted.effects[[k]][i])
      if (i>1) sortedx[k] <- paste(sortedx[k],"^",sorted.effects[[k]][i],sep="")
    }
  }
  sortedx     
}


#' @noRd
dscoords.fun <- function(DStype, feffects, ceffects.table.fb, larger.fontlabelmultiplier,
                         smaller.fontlabelmultiplier, middle.fontlabelmultiplier) {
  if (DStype=="LS"){
    xfinaleffects <- feffects
    xceffects.table.final.brief <- ceffects.table.fb
  }
  if (DStype=="RLS"){
    xfinaleffects <- feffects
    xceffects.table.final.brief <- ceffects.table.fb
  }
  
  finaleffects.reverse <- c(xfinaleffects[length(xfinaleffects):2],0,xfinaleffects[1],0)
  
  coordsy <- 95 - 90* finaleffects.reverse / finaleffects.reverse[1]
  no.perlevel.reverse <- c(table(xfinaleffects)[length(table(xfinaleffects)):2],3)  #How many effects per level plus 3 at mean level
  max.no.perlevel <- max(no.perlevel.reverse)
  index.x <- 0
  coordsx <- rep(NA,length(coordsy))
  textlabel.size <- rep(larger.fontlabelmultiplier*1,length(coordsy))
  textlabel.size.df <- rep(larger.fontlabelmultiplier*0.85,length(coordsy))
  
  #Identifies whether terms in levels where there is only one term are nested in the term above -> single.nested
  #If so the term will be placed directly below the one above - else it will be moved
  single.nested <- rep(NA,length(no.perlevel.reverse))
  names(single.nested) <- names(no.perlevel.reverse)
  oneperlev <- which(xfinaleffects %in% names(no.perlevel.reverse[no.perlevel.reverse==1]))   #selects terms with one per level
  levs.with.one <- no.perlevel.reverse[no.perlevel.reverse==1]
  single.nested[names(levs.with.one)[length(oneperlev)]] <- "y"
  if (length(oneperlev) !=1) {
    for (i in (length(oneperlev)-1):1) {
      if (xceffects.table.final.brief[oneperlev,oneperlev][length(oneperlev)-i+1,length(oneperlev)-i]=="1") {
        single.nested[names(no.perlevel.reverse)== names(levs.with.one)[i]] <- "y" } else {
          single.nested[names(no.perlevel.reverse)== names(levs.with.one)[i]] <- "n" }
    }
  }
  
  single.coord <- 50
  for (m in 1:length(no.perlevel.reverse))  {
    upper <- no.perlevel.reverse[m]-1
    for (k in upper:0)  {
      index.x <- index.x + 1
      if (max.no.perlevel > 2) {
        leftd <- (30*max.no.perlevel-28*no.perlevel.reverse[m])/(max.no.perlevel-2)
        rightd <- 100-leftd
      } else {
        leftd<-30
        rightd<-70}
      if (m==length(no.perlevel.reverse)) {
        leftd<-0
        rightd<-100
      }
      if (upper != 0) coordsx[index.x] <- leftd + (100-2*leftd)* k / upper else {
        if (single.nested[m]=="n" && single.coord==30) single.coord <- 50 else if (single.nested[m]=="n" && single.coord==50) single.coord <- 30
        coordsx[index.x] <- single.coord
      }
      if (upper > 4) textlabel.size[index.x] <- smaller.fontlabelmultiplier*0.5
      if (upper > 4) textlabel.size.df[index.x] <- smaller.fontlabelmultiplier*0.5
      if ((length(grep("=",colnames(xceffects.table.final.brief)[length(colnames(xceffects.table.final.brief)):1][index.x]))>0) && (textlabel.size[index.x]==smaller.fontlabelmultiplier*0.5)) {
        textlabel.size[index.x] <- middle.fontlabelmultiplier*0.75  
      }
    }
  }
  
  coords.output <- list(coords=cbind(coordsx,coordsy),textlabel.size=textlabel.size,textlabel.size.df=textlabel.size.df )
  coords.output
}








#' @noRd
ordinal <- function(n) {
  if (n %% 100 %in% 11:13) {
    suffix <- "th"
  } else {
    suffix <- switch(as.character(n %% 10),
                     "1" = "st",
                     "2" = "nd",
                     "3" = "rd",
                     "th")
  }
  paste0(n, suffix)
}

  
#' @noRd
dfs.fun <- function(DStype, noall, feffects, ceffects.table.fb, adjm, outputlistip1,
                    maxfacs, maxlevels.df, check.confound.df,
                    datadesign, finalnames.effects = NULL) {
  
  if (DStype %in% c("LS", "RLS")) {
    xfinaleffects <- feffects
    xfinaldesign.effects <- names(feffects)
    xadjm <- adjm
    xceffects.table.final.brief <- ceffects.table.fb
  }
  
  ## ------------------------------------------------------------
  ## Set up DF table
  ## ------------------------------------------------------------
  xdfs <- matrix(NA, nrow = length(xfinaleffects), ncol = 4)
  rownames(xdfs) <- names(xfinaleffects)
  colnames(xdfs) <- c("Tier", "Maxlev", "Actlev", "DFs")
  xdfs[, 1] <- xfinaleffects
  
  numberlevs <- apply(outputlistip1$designi, 2, function(x) length(unique(x)))
  
  if (DStype == "LS") {
    xdfs[, 3] <- numberlevs
  } else {
    xdfs[, 3] <- numberlevs[finalnames.effects %in% xfinaldesign.effects]
  }
  
  ## Mean
  xdfs[1, 2] <- 1
  xdfs[1, 4] <- 1
  
  ## First-tier effects
  for (i in seq_along(xfinaleffects)) {
    if (xfinaleffects[i] == 1) {
      xdfs[i, 2] <- xdfs[i, 3]
      xdfs[i, 4] <- xdfs[i, 3] - 1
    }
  }
  
  ## ------------------------------------------------------------
  ## Maximum levels
  ## ------------------------------------------------------------
  if (DStype == "RLS") {
    names(xfinaleffects) <- xfinaldesign.effects
    names(numberlevs) <- finalnames.effects
  } else {
    names(numberlevs) <- names(xfinaleffects)
  }
  
  numberlevs <- c("-" = 1, numberlevs)
  
  factor.finaldfeffectsi <- array("-", dim = c(length(xfinaleffects), maxfacs))
  
  for (k in seq_along(xfinaleffects)) {
    facs <- sort(unique(extract.factor.fun(names(xfinaleffects)[k])))
    factor.finaldfeffectsi[k, ] <- c(facs, rep("-", maxfacs - length(facs)))
  }
  
  maxlevels <- rep(1, nrow(factor.finaldfeffectsi))
  maxlevelsf <- rep("", nrow(factor.finaldfeffectsi))
  
  for (i in seq_len(nrow(factor.finaldfeffectsi))) {
    for (j in seq_len(ncol(factor.finaldfeffectsi))) {
      maxlevels[i] <- maxlevels[i] * numberlevs[factor.finaldfeffectsi[i, j]]
    }
    if (factor.finaldfeffectsi[i, 2] != "-" && maxlevels.df)
      maxlevelsf[i] <- paste0("(", maxlevels[i], ")")
  }
  
  xdfs[, 2] <- maxlevels
  
  ## Subtraction DF logic
  for (m in (length(xfinaleffects[xfinaleffects < 2]) + 1):length(xfinaleffects)) {
    xdfs[m, 4] <- xdfs[m, 3] -
      sum(xadjm[m,
                xfinaleffects < xfinaleffects[m]] *
            xdfs[xfinaleffects < xfinaleffects[m], 4])
  }
  

  ## ------------------------------------------------------------
  ## CONFOUNDED DF CHECK 
  ## ------------------------------------------------------------
  if (check.confound.df) {
    
    tiers <- sort(unique(xdfs[, 1]))
    n_tiers <- length(tiers)
    
    rank_by_tier <- integer(n_tiers)
    expected_df_by_tier <- integer(n_tiers)
    confounded_df_by_tier <- integer(n_tiers)
    
    # bottom (residual / observational unit)
    bottom_term <- rownames(xceffects.table.final.brief)[nrow(xceffects.table.final.brief)]
    
    for (ti in seq_along(tiers)) {
      
      ## cumulative structural objects up to this tier
      terms_t <- rownames(xceffects.table.final.brief)[xdfs[, 1] <= tiers[ti]]
      
      ## drop residual / observational unit
      terms_t <- setdiff(terms_t, bottom_term)
      
      ## remove Mean from rank computation
      terms_no_mean <- setdiff(terms_t, "Mean")
      
      ## expected DF up to this tier (excluding residual)
      idx <- (xdfs[, 1] <= tiers[ti]) & (rownames(xdfs) != bottom_term)
      expected_df <- sum(xdfs[idx, 4], na.rm = TRUE)
      
      expected_df_by_tier[ti] <- expected_df
      

      if (length(terms_no_mean) == 0) {
        rank_by_tier[ti] <- 0L
        confounded_df_by_tier[ti] <- 0L
        next
      }
      
      ## build RHS model
      model.fac <- model.effects.fun(c("Mean", terms_no_mean))
      model.eq  <- model.equation.fun(model.fac)
      
      rhs_formula <- as.formula(
        paste("~", as.character(as.formula(model.eq))[3])
      )
      
      rank_t <- tryCatch(
        qr(model.matrix(rhs_formula, datadesign))$rank,
        error = function(e) NA_integer_
      )
      
      rank_by_tier[ti] <- rank_t
      
      if (!is.na(rank_t) && rank_t < expected_df) {
        confounded_df_by_tier[ti] <- expected_df - rank_t
      } else {
        confounded_df_by_tier[ti] <- 0L
      }
    }
    
    ## ------------------------------------------------------------
    ## Reporting
    ## ------------------------------------------------------------
    total_confounded_df <- max(confounded_df_by_tier, na.rm = TRUE)
    
    if (total_confounded_df > 0) {
      
      first_confounded_tier <- tiers[min(which(confounded_df_by_tier > 0))]
      first_confounded_tier_ordinal <- ordinal(first_confounded_tier)
      
      cat(
        "\nThere are", total_confounded_df,
        "confounded degrees of freedom in the Hasse Diagram.\n",
        "Confounding first occurs at the", first_confounded_tier_ordinal, "order factors / generalised factors.\n\n"
      )
      
      term_tier <- xdfs[-1, 1]
      term_df   <- xdfs[-1, 4]
      
      ## tiers that actually have rank deficiency
      confounded_tiers <- tiers[confounded_df_by_tier > 0]
      
      
      print.dfs <- data.frame(
        "Actual levels" = xdfs[-1, 3],
        "DF by Subtraction" = term_df,
        "Potential confounded DF" = ifelse(
          term_df > 0 & term_tier %in% confounded_tiers,
          "Yes",
          "No"
        ),
        row.names = rownames(xdfs)[-1],
        check.names = FALSE
      )
      
      ## keep only confounded terms
      print.dfs <- print.dfs[print.dfs[["Potential confounded DF"]] == "Yes", , drop = FALSE]
      
      ## print only if any remain
      if (nrow(print.dfs) > 0) {
        print(print.dfs)
      }
      
    }
  }
  
  ## ------------------------------------------------------------
  ## Output
  ## ------------------------------------------------------------
  xdfs.reverse <- rbind(
    xdfs[nrow(xdfs):2, ],
    c(0, 0, 0, 0),
    Mean = xdfs[1, ],
    c(0, 0, 0, 0)
  )
  
  maxlevelsf.reverse <- c(maxlevelsf[nrow(xdfs):2], "", "", "")
  
  dfs.fun.output <- list(
    xdfs = xdfs,
    xdfs.reverse = xdfs.reverse,
    maxlevelsf.reverse = maxlevelsf.reverse
  )
  
  dfs.fun.output
}




#' @noRd
anyna <- function(x) {any(is.na(x))}



#' @noRd
.build_layout_structure <- function(datadesign, randomfacsid = NULL) {
  
  if (!is.data.frame(datadesign)) {
    tryCatch({
      datadesign <- as.data.frame(datadesign)
    }, error = function(e) {
      stop("Argument 'datadesign' must be a data frame or coercible to one via as.data.frame().", call. = FALSE)
    })
  }
  
  old_names <- colnames(datadesign)
  new_names <- gsub(" ", "_", old_names)
  if (!identical(old_names, new_names)) {
    colnames(datadesign) <- new_names
    warning("Spaces in datadesign column names have been replaced with underscores.", call.=FALSE)
  }
  
  check1 <- apply(datadesign, 2, function(a) length(unique(a))==1)
  if (any(check1==TRUE)) {
    stop("One or more factors contain only identical elements.", call.=FALSE)
  }
  
  if (length(colnames(datadesign)[apply(datadesign,2,anyna)])>0) {
    stop(
      paste(
        "The factor(s) '",
        paste(colnames(datadesign)[apply(datadesign, 2, anyNA)], collapse = ", "),
        "' have missing values. Please check and correct the dataset."
      ),
      call. = FALSE
    )
  }
  
  nfacts <- ncol(datadesign)
  if (!is.null(randomfacsid)) {
    if (!is.numeric(randomfacsid)) {
      stop("Argument 'randomfacsid' must be a numeric vector containing only 0s and 1s.", call. = FALSE)
    }
    if (any(!randomfacsid %in% c(0, 1))) {
      stop("Argument 'randomfacsid' must contain only 0s (fixed) and 1s (random).", call. = FALSE)
    }
    if (ncol(datadesign) != length(randomfacsid)) {
      stop("The length of 'randomfacsid' should be equal to the number of columns of 'datadesign'.", call. = FALSE)
    }
  } else {
    randomfacsid <- rep(0, nfacts)
  }
  
  
  datadesign <- cbind(Mean=rep(1,length(datadesign[ ,1])),datadesign[ , ])
  
  
  
  abbrev.length <- rep(2,length(colnames(datadesign)[-1]))
  names(abbrev.length) <- colnames(datadesign)[-1]
  
  if (max(table(substring(colnames(datadesign)[-1],1,2)))>1) {
    if (max(table(substring(colnames(datadesign),1,3)))>1) {
      stop("The program abbreviates factor names using the first 2 or 3 letters. It has found that two factors have the same abbreviation. Please rename to avoid this issue.", call.=FALSE)
    } else {
      abbrev.length[substring(names(abbrev.length),1,2) %in% (names(table(substring(colnames(datadesign),1,2)))[table(substring(colnames(datadesign),1,2))==2])] <- 3
    }
  }
  
  main.effects.table <- structure.fun(datadesign)
  
  rm.effecti <- 0
  rm.effectj <- 0
  no.effectsi <- length(colnames(main.effects.table))
  for (i in 1:(no.effectsi-1)) {
    for (j in (i+1):no.effectsi) {
      if (main.effects.table[i,j]=="1" & main.effects.table[j,i]=="1") {
        rm.effecti <- c(rm.effecti,i)
        rm.effectj <- c(rm.effectj,j)
      }
    }
  }
  
  # if (length(rm.effecti)>1) {
  #   rm.effecti <- rm.effecti[-1]
  #   rm.effectj <- rm.effectj[-1]
  #   for (k in (1:length(rm.effecti))) {
  #     warning(colnames(main.effects.table)[rm.effecti[k]]," is confounded with ",colnames(main.effects.table)[rm.effectj[k]],"\n\n")
  #   }
  #   
  #   if (max(table(rm.effecti)) > 1 || max(table(rm.effectj)) >1 ) {
  #     warning("There are three (or more) main effects which are confounded. The program only processes single or pairs of equivalent factors.
  #         Please remove at least one factor from any triple set of equivalent factors.", call.=FALSE)
  #   } else {
  #     warning("There are main effects which are equivalent. If this relationship is unintentional review the design and correct as appropriate.
  #         The program will proceed by using only one factor for each equivalent pair of factors.", call.=FALSE)     
  #   }      
  #   
  #   datadesign <- datadesign[ ,-(rm.effectj)]  
  #   randomfacsid<-randomfacsid[-(rm.effectj-1)]                                   
  #   
  #   confound.factor <- cbind(colnames(main.effects.table)[rm.effectj],colnames(main.effects.table)[rm.effecti]) 
  # }                  
  
  if (length(rm.effecti) > 1) {
    
    rm.effecti <- rm.effecti[-1]
    rm.effectj <- rm.effectj[-1]
    
    pairs <- paste(
      colnames(main.effects.table)[rm.effecti],
      "is equivalent to",
      colnames(main.effects.table)[rm.effectj]
    )
    
    warning(
      paste(
        "Equivalent (identical) main effects detected:",
        paste(pairs, collapse = "; "),
        "\nThe program will proceed by using only one factor from each equivalent pair.",
        "If this is unintentional, please revise the design."
      ),
      call. = FALSE
    )
    
    datadesign   <- datadesign[, -rm.effectj, drop = FALSE]
    randomfacsid <- randomfacsid[-(rm.effectj - 1)]
    
    confound.factor <- cbind(
      colnames(main.effects.table)[rm.effectj],
      colnames(main.effects.table)[rm.effecti]
    )
  }
  
  
  levs <- apply(datadesign, 2, function (x) {length(unique(x))})
  resid.yn <- TRUE
  if (nrow(datadesign) %in% levs) resid.yn <- FALSE
  if (resid.yn == TRUE) {
    datadesign <- cbind(datadesign,obs.unit=(1:nrow(datadesign)))
    abbrev.length <- c(abbrev.length,obs.unit=8)
  }
  
  maxfacs <- length(colnames(datadesign))
  randomfacsidm <- c(0,randomfacsid)   
  if (resid.yn == TRUE) randomfacsidm<-c(randomfacsidm, 1) 
  
  randomfacs<-colnames(datadesign)[randomfacsidm==1]
  
  keep.order.effects0 <- "Mean"
  
  main.effects.table <- structure.fun(datadesign)
  
  orig.order <- order(rownames(main.effects.table))
  xtable <- main.effects.table[orig.order,orig.order]
  
  prelim.effect.order <- c(rep(NA, nrow(xtable)))
  for (i in 1:nrow(main.effects.table)) {
    prelim.effect.order[i] <- length(xtable[i,(xtable[i, ]=="1")])
  }
  
  xtable.print <- as.data.frame(cbind(xtable,prelim.effect.order))
  
  sort.prelim <- order(prelim.effect.order)
  sort.ord <- c(1:nrow(xtable))[orig.order][sort.prelim]
  
  main.effects.table <- main.effects.table[sort.ord,sort.ord]
  main.effects.table.print <- as.data.frame(cbind(main.effects.table,prelim.effect.order=prelim.effect.order[sort.prelim]))
  prelim.effect.order <- prelim.effect.order[sort.prelim]
  
  main.effects.table.print <- data.frame(lapply(main.effects.table.print, as.character), stringsAsFactors=FALSE)
  rownames(main.effects.table.print) <- rownames(main.effects.table)
  main.effects.table.print[1, (2:(ncol(main.effects.table.print)-1))] <- "(0)"
  
  main.effects.table.nestnames <- rownames(main.effects.table)
  main.effects.table.nestintnames <- rownames(main.effects.table)
  
  for (i in 2:length(rownames(main.effects.table))) {
    first <- 1
    for (j in 2:length(rownames(main.effects.table))) {
      if (main.effects.table[i,j]==1 & i != j) {
        if (first==1) {main.effects.table.nestnames[i] <- paste(main.effects.table.nestnames[i],"(",rownames(main.effects.table)[j],sep="")} else
          main.effects.table.nestnames[i] <- paste(main.effects.table.nestnames[i],"^",rownames(main.effects.table)[j],sep="")
        first <- 0
        main.effects.table.nestintnames[i] <- paste(main.effects.table.nestintnames[i],"^",rownames(main.effects.table)[j],sep="")
      }
    }
    if (first==0) {
      main.effects.table.nestnames[i] <- paste(main.effects.table.nestnames[i],")",sep="")
    }
  }
  
  orderi <- 1
  order.effects1<-rownames(main.effects.table[prelim.effect.order==orderi, ,drop=F])
  order.effects<-c("Mean",order.effects1)    #Add in effects from lower order i.e. order 0 = Mean
  level.order.effects1<-c(0,rep(1,length(order.effects1)))    #identify which order the effect is added
  design1 <- datadesign[ ,order.effects]
  effects.table.order1 <- structure.fun(design1)
  
  orderi <- 2
  outputlist2 <- designorder(2,orderi,design1,order.effects1,level.order.effects1,"","","", main.effects.table.nestintnames, main.effects.table, prelim.effect.order, maxfacs, datadesign)
  level.order.objectsi_1 <- level.order.effects1
  outputlistip1 <- outputlist2
  order.effectsi_1 <- order.effects1
  
  for (level in 3:eval(maxfacs-1)) {
    outputlisti <- outputlistip1
    designi <-  outputlisti$designi
    level.order.objectsi <- c(level.order.objectsi_1,rep(eval(orderi),(length(colnames(designi))-length(level.order.objectsi_1))))
    orderip1 <- eval(orderi+1)
    order.effectsi <- colnames(designi)[level.order.objectsi==orderi]
    
    outputlistip1 <- designorder(level,orderip1,designi,order.effectsi,level.order.objectsi,outputlisti$keep.nested.objectsi,outputlisti$keep.nested.interactionsi,outputlisti$keep.order.objectsiuniqi, main.effects.table.nestintnames, main.effects.table, prelim.effect.order, maxfacs, datadesign)
    
    level.order.objectsi_1 <- level.order.objectsi
    order.effectsi_1 <- order.effectsi
    orderi <- orderip1
  }
  
  finaleffects <- outputlistip1$level.order.objectsi
  names(finaleffects) <- colnames(outputlistip1$designi)
  
  finaleffectrandom <- rep(NA, length(names(finaleffects)))
  for (m in 1:length(names(finaleffects))) {
    finaleffectrandom[m]<-0
    if (length(randomfacs)>0) {
      for (i in 1:length(randomfacs)) {
        finaleffectrandom[m] <- max(grep(randomfacs[i],names(finaleffects)[m]),finaleffectrandom[m])
      }
    }
  }
  names(finaleffectrandom) <- names(finaleffects)
  
  effects.table.final <- structure.fun(outputlistip1$designi)
  effects.table.final.brief <- effects.table.final
  effects.table.final.brief[1,2:ncol(effects.table.final.brief)] <- "(0)"
  ceffects.table.final.brief <- effects.table.final
  ceffects.table.final.brief[1,2:ncol(effects.table.final.brief)] <- "(0)"
  brief.colnames <- sapply(colnames(effects.table.final), brief.effect.fun, abbrev.length)
  colnames(effects.table.final.brief) <- brief.colnames
  colnames(ceffects.table.final.brief) <- brief.colnames
  
  confounded.main <- colnames(datadesign)[sort.ord[-1]][!(colnames(datadesign)[sort.ord[-1]] %in% colnames(outputlistip1$designi))]
  
  no.confounded <- length(confounded.main)
  noall <- length(colnames(outputlistip1$designi))
  conf.nestedin.all.table <- matrix(" ",nrow=no.confounded,ncol=noall)
  all.nestedin.conf.table <- matrix(" ",nrow=noall,ncol=no.confounded)
  
  for (effectalli in 1:noall) {
    if (no.confounded > 0) {
      for (confoundi in 1:no.confounded) {     
        freq.table <- table(datadesign[ ,sort.ord][ ,confounded.main[confoundi]],outputlistip1$designi[ ,effectalli])
        nestk <- rep(0, length=nrow(freq.table))   #Set up factor for all k levels of factorj to indicate whether nested within factor i
        for (k in 1:nrow(freq.table)) {
          if (min(freq.table[k,])==0 && table(freq.table[k, ])[1]+1==ncol(freq.table)) nestk[k] <- 1 else
            if (min(freq.table[k, ])==0) nestk[k] <- 0.5 else nestk[k] <- 0
        }
        conf.nestedin.all.table[confoundi,effectalli] <- if (all(nestk==1)) "1" else if (all(nestk==0)) "0" else "(0)"
      }
    }
  }
  
  if (no.confounded > 0) {
    for (confoundi in 1:no.confounded) {
      for (effectalli in 1:noall) {
        freq.table <- table(outputlistip1$designi[ ,effectalli],datadesign[ ,sort.ord][ ,confounded.main[confoundi]])
        nestk <- rep(0, length=nrow(freq.table))   #Set up factor for all k levels of factorj to indicate whether nested within factor i
        for (k in 1:nrow(freq.table)) {
          if (min(freq.table[k,])==0 && table(freq.table[k, ])[1]+1==ncol(freq.table)) nestk[k] <- 1 else
            if (min(freq.table[k, ])==0) nestk[k] <- 0.5 else nestk[k] <- 0
        }
        all.nestedin.conf.table[effectalli,confoundi] <- if (all(nestk==1)) "1" else if (all(nestk==0)) "0" else "(0)"
      }
    }
  }
  
  confound.tab <- confound.tab.fun(no.confounded, noall, all.nestedin.conf.table, conf.nestedin.all.table, confounded.main, outputlistip1)
  
  confound.tab<-cbind(confound.tab,confound.tab[ ,1])
  if (exists("confound.factor")) {
    confound.factor<-cbind(confound.factor,confound.factor[ ,1])
    if (dim(confound.tab)[1] > 0) {
      confound.factork <- NULL
      #This checks for equivalent factors also equivalent to an interaction
      if(nrow(confound.factor) > 0) { 
        for (j in 1:nrow(confound.tab)) {
          for (k in 1:nrow(confound.factor)) {
            if (confound.tab[j,3] == confound.factor[k,2]) {
              confound.tab[j,3] <- paste(confound.factor[k,3],"=", confound.tab[j,3],sep="")
              confound.factork <- c(confound.factork,k)
              confound.factork.y <- TRUE
            }
          }
        }
      }
      if (exists("confound.factork.y")) {
        confound.tab <- rbind(confound.factor[-confound.factork, ],confound.tab) }
    } else {
      confound.tab <-confound.factor
    }
  }    
  
  if (no.confounded>0) {
    contain <- rep(NA,nrow(confound.tab))
    for (i in 1:nrow(confound.tab)) {
      contain[i] <- confound.tab[i,1] %in% extract.factor.fun(confound.tab[i,2])
    }
    confound.tab <- cbind(confound.tab,contain)
  } else {
    confound.tab <- cbind(confound.tab,confound.tab[ ,3])
  }
  
  contain.false <- confound.tab[confound.tab[ ,4]=="FALSE",1]   #Selects factors equivalent to an interaction which doesn't contain them
  confound.tab <- cbind(confound.tab,inclequiv.factors=confound.tab[ ,2])     #puts in last column original names including names of equivalent factors
  
  for (i in 1: length(contain.false)) {
    if ((length(contain.false) > 0)&& (contain.false[i]!=confound.tab[i,1])) {
      removeb<-paste("\\^",contain.false[i],sep="")
      removea<-paste(contain.false[i],"\\^",sep="")
      removeb.brief<-paste("\\^",substring(contain.false[i],1,abbrev.length[contain.false[i]]),sep="")
      removea.brief<-paste(substring(contain.false[i],1,abbrev.length[contain.false[i]]),"\\^",sep="")
      confound.tab[ ,2]<-gsub(paste(removeb),"",confound.tab[ ,2])
      confound.tab[ ,2]<-gsub(paste(removea),"",confound.tab[ ,2])
      names(finaleffects)<-gsub(paste(removea),"",names(finaleffects))
      names(finaleffects)<-gsub(paste(removeb),"",names(finaleffects))
      brief.colnames<-gsub(paste(removea.brief),"",brief.colnames)
      brief.colnames<-gsub(paste(removeb.brief),"",brief.colnames)
      colnames(effects.table.final.brief)<-gsub(paste(removea.brief),"",colnames(effects.table.final.brief))
      colnames(effects.table.final.brief)<-gsub(paste(removeb.brief),"",colnames(effects.table.final.brief))
      rownames(effects.table.final.brief)<-gsub(paste(removea),"",rownames(effects.table.final.brief))
      rownames(effects.table.final.brief)<-gsub(paste(removeb),"",rownames(effects.table.final.brief))
    }
  }
  
  
  for (i in 1:nrow(confound.tab)) {
    if ((confound.tab[i,1] %in% randomfacs) && (finaleffectrandom[confound.tab[i,5]]==0)) {
      warning("\n", confound.tab[i,1]," was defined as random but it is equivalent to ", names(finaleffectrandom[confound.tab[i,5]]), 
              " which has all its component factors as fixed. \n", names(finaleffectrandom[confound.tab[i,5]]),
              " will be assumed to be random to align with ", confound.tab[i,1], ".",
              " If this is incorrect please change the random/fixed designation of the factor.", call.=FALSE)
      finaleffectrandom[confound.tab[i,5]]<-1
    }
    
    if (!(confound.tab[i,1] %in% randomfacs) && (finaleffectrandom[confound.tab[i,5]]==1)) {
      warning("\n", names(finaleffectrandom[confound.tab[i,5]]),
              " will be assumed to be random. \n", 
              confound.tab[i,1]," was defined as fixed but it is equivalent to ", names(finaleffectrandom[confound.tab[i,5]]), 
              " and therefore will also be considered as random.",
              " If this is incorrect please change the random/fixed designation of the term.", call.=FALSE)
    }
  }
  
  if (exists("userfinaleffectrandom")) {
    names(userfinaleffectrandom)<- names(finaleffectrandom)
    bothfinaleffectrandom <- cbind(finaleffectrandom,userfinaleffectrandom)
    
    Default_designation <-c(rep(NA  , length(finaleffectrandom)))
    User_defined_designation <-c(rep(NA  , length(finaleffectrandom)))
    for (i in 1:length(finaleffectrandom)) {
      if (finaleffectrandom[i] == "1") { 
        Default_designation[i] <- "Random"
      } else { 
        Default_designation[i] <- "Fixed "
      }
      
      if (userfinaleffectrandom[i] == "1") { 
        User_defined_designation[i] <- "Random"
      } else { 
        User_defined_designation[i] <- "Fixed "
      }
    }
    
    names(Default_designation)<- names(finaleffectrandom)
    names(User_defined_designation)<- names(finaleffectrandom)
    bothfinaleffectrandom_SilveR <- cbind(Default_designation,User_defined_designation)
    
    if (any(userfinaleffectrandom!=finaleffectrandom)) {
      warning("The random/fixed designation of a term has been changed by the user. The user designation will be used by the program but please chack it is appropriate.", call.=FALSE)
      print(bothfinaleffectrandom)
      finaleffectrandom <- userfinaleffectrandom
    }
  }
  
  main.effects.table.order <- main.effects.table.print[order(prelim.effect.order),order(prelim.effect.order)]
  main.effects.mat <- matrix(NA,nrow=nrow(main.effects.table.order),ncol=ncol(main.effects.table.order),dimnames=dimnames(main.effects.table.order))
  for (i in 1:nrow(main.effects.table.order)) {
    for (j in 1:ncol(main.effects.table.order)) {
      if (main.effects.table.order[i,j]=="1") main.effects.mat[i,j] <- 1
      if (main.effects.table.order[i,j]=="0") main.effects.mat[i,j] <- 0
      if (main.effects.table.order[i,j]=="(0)") main.effects.mat[i,j] <- 0
      if (main.effects.table.order[i,j]==" ") main.effects.mat[i,j] <- 0
    }
  }
  
  effects.equiv.interaction <- confound.tab[(confound.tab[ ,4]=="FALSE"),1]    
  
  if (nrow(confound.tab) > 0) {
    if ((length(effects.equiv.interaction)>0) && (any(rownames(main.effects.mat) %in% effects.equiv.interaction)) ) {
      main.effects.mata <- main.effects.mat[-which(rownames(main.effects.mat) %in% effects.equiv.interaction),-which(rownames(main.effects.mat) %in% effects.equiv.interaction)]
    }  else {main.effects.mata <- main.effects.mat}
    for (i in 1:nrow(main.effects.mata)) {
      for (j in 1:ncol(main.effects.mata)) {
        if (main.effects.mata[i,j]==1) {
          for (k in 1:nrow(main.effects.mata)) {
            main.effects.mata[i,k] <- max(main.effects.mata[i,k]-main.effects.mata[j,k],0)
          }
        }
      }
    }
  } 
  
  if (dim(confound.tab)[1] > 0) {
    for (i in 1:dim(confound.tab)[1]) {
      for (j in 1:length(colnames(ceffects.table.final.brief))) {
        if (names(colnames(ceffects.table.final.brief))[j] == confound.tab[i,5]) {
          colnames(ceffects.table.final.brief)[j]<-paste(confound.tab[i,3],"=",brief.colnames[confound.tab[i,5]],sep="") }
      }
    }
  }
  
  main.effects.mat.brief<-substr(rownames(main.effects.mata),1,c(4,abbrev.length[rownames(main.effects.mata)[-1]]))
  main.effects.table.nestnames <- rownames(main.effects.mata)                                                                                                                     
  main.effects.mat.nestbrief <- main.effects.mat.brief
  
  for (i in 2:length(rownames(main.effects.mata))) {
    if (no.confounded>0) {
      if (rownames(main.effects.mata)[i] %in% confound.tab[ ,1] && (confound.tab[confound.tab[ ,1]==rownames(main.effects.mata)[i],4]==T)){
        first <- 1
        for (j in 2:length(colnames(main.effects.mata)))  {
          if (main.effects.mata[i,j]==1 & i != j) {
            if (first==1) {
              main.effects.table.nestnames[i] <- paste(main.effects.table.nestnames[i],"(",main.effects.table.nestnames[colnames(main.effects.mata)==colnames(main.effects.mata)[j]],sep="")
              main.effects.mat.nestbrief[i] <- paste(main.effects.mat.nestbrief[i],"(",main.effects.mat.nestbrief[main.effects.mat.brief == main.effects.mat.brief[j]],sep="")      
            } else {
              main.effects.table.nestnames[i] <- paste(main.effects.table.nestnames[i],"^",main.effects.table.nestnames[rownames(main.effects.mata)==rownames(main.effects.mata)[j]],sep="")
              main.effects.mat.nestbrief[i] <- paste(main.effects.mat.nestbrief[i],"^",main.effects.mat.nestbrief[-1][main.effects.mat.brief[-1] == main.effects.mat.brief[j]],sep="")
            }
            first <- 0
          }
        }
        if (first==0) {
          main.effects.table.nestnames[i] <- paste(main.effects.table.nestnames[i],")",sep="")
          main.effects.mat.nestbrief[i] <- paste(main.effects.mat.nestbrief[i],")",sep="")        
        }
      }
    }
  }
  
  main.effects.table.nestnames <- cbind(rownames(main.effects.mata),main.effects.table.nestnames,main.effects.mat.brief,main.effects.mat.nestbrief)
  
  nested.names <- main.effects.table.nestnames[main.effects.table.nestnames[ ,1] %in% confound.tab[confound.tab[ ,4]==T,1], ,drop=F]
  nested.names <- cbind(nested.names,confound.tab[confound.tab[ ,4]==T,2])
  
  namesind.effects <- matrix(NA,nrow=length(names(finaleffects)),ncol=length(names(finaleffects)))
  
  for (i in 1:length(names(finaleffects))){
    extract<-extract.factor.fun(names(finaleffects)[i])
    for (j in 1:length(extract)) {
      namesind.effects[i,j] <- extract[j]
    }
  }
  
  namesind.effects <- namesind.effects[,colSums(is.na(namesind.effects))<nrow(namesind.effects)]
  
  namesind.briefeffects <- matrix(NA,nrow=length(colnames(effects.table.final.brief)),ncol=length(colnames(effects.table.final.brief)))
  
  for (i in 1:length(colnames(effects.table.final.brief))){
    extract<-extract.factor.fun(colnames(effects.table.final.brief)[i])
    for (j in 1:length(extract)) {
      namesind.briefeffects[i,j] <- extract[j]
    }
  }
  
  namesind.briefeffects <- namesind.briefeffects[,colSums(is.na(namesind.briefeffects))<nrow(namesind.briefeffects)]
  
  cnamesind.briefeffects <- matrix(NA,nrow=length(colnames(ceffects.table.final.brief)),ncol=ncol(main.effects.mat))
  for (i in 1:length(colnames(ceffects.table.final.brief))){
    extract<-extract.factor.fun(colnames(ceffects.table.final.brief)[i])
    for (j in 1:length(extract)) {
      cnamesind.briefeffects[i,j] <- extract[j]
    }
  }
  
  nestednamesind <- matrix(NA,nrow=nrow(nested.names),ncol=length(names(finaleffects)))
  
  if (nrow(nested.names)>0) {
    for (i in 1:nrow(nested.names)) {
      extract<-extract.factor.fun(nested.names[i,5])
      for (j in 1:length(extract)) {
        nestednamesind[i,j] <- extract[j]
      }
    }
  }
  
  nestednamesind.brief <- substr(nestednamesind,1,abbrev.length[nestednamesind])
  
  for (m in 1:nrow(namesind.effects)) {           
    if (nrow(nested.names)>0) {
      for (k in nrow(nested.names):1) {           
        if (nested.names[k,1] %in% namesind.effects[m, ]) {
          if (ncol(namesind.effects)>0) {
            for (r in 1:ncol(namesind.effects)) {       
              if (ncol(nestednamesind)>0) {
                for (p in 1:ncol(nestednamesind)) {      
                  if (!is.na(namesind.effects[m,r]) && !is.na(nestednamesind[k,p]) && nested.names[k,1] != namesind.effects[m,r] 
                      && namesind.effects[m,r]==nestednamesind[k,p]) { namesind.effects[m,r]<-NA }
                }
              }
            }
          }
        }
      }
    }
  }
  
  for (m in 1:nrow(namesind.briefeffects)) {
    if(nrow(nested.names)>0) {
      for (k in nrow(nested.names):1) {
        if (nested.names[k,3] %in% namesind.briefeffects[m, ]) {
          if (ncol(namesind.briefeffects)>0) {
            for (r in 1:ncol(namesind.briefeffects)) {
              if (ncol(nestednamesind.brief)>0) {
                for (p in 1:ncol(nestednamesind.brief)) {
                  if (!is.na(namesind.briefeffects[m,r]) && !is.na(nestednamesind.brief[k,p]) && nested.names[k,3] != namesind.briefeffects[m,r] && namesind.briefeffects[m,r]==nestednamesind.brief[k,p]) {
                    cnamesind.briefeffects[m,r]<-gsub(nestednamesind.brief[k,p],"",cnamesind.briefeffects[m,r])   #Replaces nested main effect by "" - note this may be contained within a term
                    if (!is.na(cnamesind.briefeffects[m,r]) && cnamesind.briefeffects[m,r]=="") {cnamesind.briefeffects[m,r]<-NA}   #Replaces cells in matrix which are "" by NA
                  } 
                }
              }
            }
          }
        }
      }
    }
  }
  
  finalnamesind.effects<-namesind.effects
  finalnamesind.briefeffects<-cnamesind.briefeffects
  finalnames.effects <- rep(NA,nrow(namesind.effects))
  finalnames.briefeffects <- rep(NA,nrow(namesind.effects))
  for (m in 1:nrow(namesind.effects)) {
    for (r in 1:ncol(namesind.effects)) {
      if(nrow(nested.names)>0) {
        for (k in 1:nrow(nested.names)) {
          if (nested.names[k,1] %in% namesind.effects[m,r]) { 
            finalnamesind.effects[m,r]<-gsub(nested.names[k,1],nested.names[k,2],namesind.effects[m,r])      
            if(length(strsplit(cnamesind.briefeffects[m,r],"=")[[1]])<=1) {
              finalnamesind.briefeffects[m,r]<-sub(nested.names[k,3],nested.names[k,4],cnamesind.briefeffects[m,r])
            } else {         
              finalnamesind.briefeffects[m,r]<-paste(substr(cnamesind.briefeffects[m,r],1,gregexpr("=",
                                                                                                   cnamesind.briefeffects[m,r])[[1]][length(strsplit(cnamesind.briefeffects[m,r],"=")[[1]])-1]), nested.names[k,4] ,sep="")
            }          
          }
        }
      }
    }
    finalnames.effects[m]<-paste(finalnamesind.effects[m,!is.na(finalnamesind.effects[m, ])], collapse="^")
    finalnames.briefeffects[m]<-paste(finalnamesind.briefeffects[m,!is.na(finalnamesind.briefeffects[m, ])], collapse="^")
    finalnames.briefeffects[m]<- gsub("=\\^","=",finalnames.briefeffects[m]  )
  }
  
  cbind(finalnames.effects,finalnames.briefeffects)
  
  confound.effects<-confound.tab[ ,1:2,drop=FALSE]
  for (i in 1:nrow(confound.effects)) {
    if(nrow(nested.names)>0) {
      for (j in 1:nrow(nested.names)) {
        if (confound.effects[i,1]==nested.names[j,1]) confound.effects[i,2]<-nested.names[j,2]  
      } 
    }
  }
  
  rownames(ceffects.table.final.brief) <- finalnames.effects
  colnames(ceffects.table.final.brief) <- finalnames.briefeffects
  
  
  
  
  #-------------------------
  # Build the TransferObject in the exact shape hasserls() expects
  #-------------------------
  rnames.effects <- rownames(ceffects.table.final.brief)
  leff <- length(rnames.effects)
  mat.vec2 <- rep("NULL", leff)
  mat.vec2[1] <- rnames.effects[1]  
  TransferObject <- cbind(
    "All Structural Objects" = rnames.effects,
    "Randomisation Objects"  = mat.vec2
  )
  rownames(TransferObject) <- seq_len(leff)
  
  #----------------------------------------------------
  # Assemble an output object needed for HD executions
  #----------------------------------------------------
  invisible(
    out <- list(
    finaleffectsnames   = rnames.effects,
    finalstructure      = ceffects.table.final.brief,
    finaleffects        = finaleffects,
    finalrandomeffects  = finaleffectrandom,
    nfactors            = maxfacs,
    outputlistip1       = outputlistip1,
    nestednames         = nested.names,
    datadesign          = datadesign)
  )
  
  out
  
}




