% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonzerocure_test.R
\name{nonzerocure_test}
\alias{nonzerocure_test}
\title{Non-parametric test for a non-zero cured fraction}
\usage{
nonzerocure_test(object, reps = 1000, seed = NULL, plot = FALSE, b = NULL)
}
\arguments{
\item{object}{a \code{survfit} object.}

\item{reps}{number of simulations on which to base the p-value
(default = 1000).}

\item{seed}{optional random seed.}

\item{plot}{logical. If TRUE a histogram of the estimated susceptible
proportions over all simulations is produced.}

\item{b}{optional. If specified the maximum observed time for the uniform
distribution for generating the censoring times. If not specified, an
exponential model is used for generating the censoring times (default).}
}
\value{
\item{proportion_susceptible}{estimated proportion of susceptibles}

\item{proportion_cured}{estimated proportion of those cured}

\item{p_value}{p-value testing the null hypothesis that the
proportion of susceptibles = 1 (cured fraction = 0) against the alternative
that the proportion of susceptibles < 1 (non-zero cured fraction)}

\item{time_95_percent_of_events}{estimated time at which 95\% of
events should have occurred}
}
\description{
Tests the null hypothesis that the proportion of observations susceptible to
the event = 1 against the alternative that the proportion of observations
susceptible to the event is < 1. If the null hypothesis is rejected, there
is a significant cured fraction.
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
km_fit <- survfit(Surv(Time, Censor) ~ 1, data = training)
nonzerocure_test(km_fit)
}
\references{
Maller, R. A. and Zhou, X. (1996) \emph{Survival Analysis with
Long-Term Survivors}. John Wiley & Sons.
}
\seealso{
\code{\link[survival]{survfit}}, \code{\link{cure_estimate}},
\code{\link{sufficient_fu_test}}
}
\keyword{htest}
