% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_3_model_method.R
\name{infer_variable_type}
\alias{infer_variable_type}
\title{Extract information of selected variables from high-dimensional Cox models}
\usage{
infer_variable_type(object, x)
}
\arguments{
\item{object}{Model object.}

\item{x}{Data matrix used to fit the model.}
}
\value{
A list containing the index, name, type and range of the
selected variables.
}
\description{
Extract the names and type of selected variables from fitted
high-dimensional Cox models.
}
\examples{
data("smart")
x <- as.matrix(smart[, -c(1, 2)])
time <- smart$TEVENT
event <- smart$EVENT
y <- survival::Surv(time, event)

fit <- fit_lasso(x, y, nfolds = 3, rule = "lambda.min", seed = 11)
infer_variable_type(fit, x)
}
