% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdrcde-package.R
\docType{data}
\name{lane2}
\alias{lane2}
\alias{lane3}
\title{Speed-Flow data for Californian Freeway}
\format{
Two data frames (\code{lane2} and \code{lane3}) each with 1318
observations on the following two variables:
\describe{
\item{flow}{a numeric vector giving the traffic flow in vehicles per lane per hour.}
\item{speed}{a numeric vector giving the speed in miles per hour.}
}
}
\source{
Petty, K.F., Noeimi, H., Sanwal, K., Rydzewski, D., Skabardonis, A.,
Varaiya, P., and Al-Deek, H.  (1996). "The Freeway Service Patrol
Evaluation Project: Database Support Programs, and Accessibility".
\emph{Transportation Research Part C: Emerging Technologies}, \strong{4},
71-85.

The data is provided by courtesy of CALIFORNIA PATH, Institute of
Transportation Studies, University of California, Berkeley.
}
\usage{
lane2; lane3
}
\description{
These are two data sets collected in 1993 on two individual lanes (lane 2
and lane 3) of the 4-lane Californian freeway I-880. The data were collected
by loop detectors, and the time units are 30 seconds per observation (see
Petty et al., 1996, for details).
}
\details{
The data is examined in Einbeck and Tutz (2006), using a nonparametric
approach to multi-valued regression based on conditional mean shift.
}
\examples{
plot(lane2)
plot(lane3)
}
\references{
Einbeck, J., and Tutz, G. (2006). "Modelling beyond regression
functions: an application of multimodal regression to speed-flow data".
\emph{Journal of the Royal Statistical Society, Series C (Applied
Statistics)}, \strong{55}, 461-475.
}
\keyword{datasets}
