% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20241206_test_function_edit.R
\name{threshold.test}
\alias{threshold.test}
\title{Uniform test for existence of threshold effects}
\usage{
threshold.test(
  data,
  response,
  running,
  id,
  bw = NULL,
  C = 0,
  alpha = NULL,
  alternative = "two"
)
}
\arguments{
\item{data}{a data frame containing the response, running and id variables}

\item{response}{name of the dependent variable (aka response variable)}

\item{running}{name of the running variable (aka forcing variable)}

\item{id}{name of the id variable}

\item{bw}{an optional scalar bandwidth parameter for the local linear estimation. If not specified, the bandwidth
is selected by the command \code{\link[rdrobust:rdbwselect]{rdrobust::rdbwselect()}}.}

\item{C}{a scalar value for the true threshold location (for the known case) or a grid of candidate threshold locations
(for the unknown case)}

\item{alpha}{specifies a threshold to determine which and how many individual-specific threshold effects and test
statistics are displayed in the output table. Only individuals which are significant at the alpha confidence level are selected.}

\item{alternative}{specifies whether we consider a two-sided alternative (default) or left-/right-sided alternative.}
}
\value{
A list containing:\tabular{ll}{
\code{I_hat} \tab the value of the uniform test statistic \cr
\tab \cr
\code{p_value} \tab the corresponding p-value \cr
\tab \cr
\code{N} \tab the cross-sectional dimension \cr
\tab \cr
\code{Critical_values} \tab critical values at 10\%, 5\%, 1\%, and 0.1\% confidence level \cr
\tab \cr
\code{Table} \tab a table displaying the estimation result for a selection of individuals, including the id variable, the threshold location,
the estimated coefficient, the estimated standard error, and the individual test statistic. \cr
}
}
\description{
Uniform test for existence of threshold effects in a nonparametric panel regression. Both the
known and unknown threshold location case are covered. Apart from the uniform test statistic and
the corresponding p-value, a table for the results of the individual threshold estimates and test statistics
is provided.
}
\examples{
d = threshold.example(10, 200, 0.1, 2)
threshold.test(data = d, response = "y", running = "x", id = "id", C = 0)
}
\seealso{
\code{\link[=threshold.example]{threshold.example()}}, \code{\link[rdrobust:rdbwselect]{rdrobust::rdbwselect()}}.
}
