with_mock_dir("ha_point", {
  test_that("check point layers list", {
    ha_set(cha_url)
    point_layers <- ha_point_layers()

    "expect a data.frame"
    expect_s3_class(point_layers, "data.frame")

    "check table names"
    expect_equal(names(point_layers), point_layers_header)

    "check more than 1 row"
    expect_gt(nrow(point_layers), 1)
  })

  test_that("check a single point layer", {
    ha_set(cha_url)
    point_layer <- ha_point_layer("7d9caf3c-75e6-4382-8c97-069696a3efbf")

    "expect a data.frame"
    expect_s3_class(point_layer, "sf")
    expect_s3_class(point_layer, "data.frame")

    "check more than 1 row"
    expect_gt(nrow(point_layer), 1)
  })
})
