% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{calc_rev}
\alias{calc_rev}
\title{Calculate 3-year Revenue for Healthcare Practice}
\usage{
calc_rev(
  procedures,
  growth = rep(0, 3),
  comp_ratio = rep(1, 4),
  ins_prop = rep(0.25, 4),
  tech_fee_mult = 10,
  month_prop = rep(1/12, 12),
  restoration = rep(1, 36),
  boost_amt = numeric(0),
  boost_proc = list(),
  boost_start = integer(0),
  boost_end = integer(0)
)
}
\arguments{
\item{procedures}{df or tibble containing 3 columns (name, annual volume, annual revenue)}

\item{growth}{numeric vector of length 3; c(1, 10, 100) would represent
expected growth of 1 percent in year 1, 10 percent in year 2
(compared to year 1), and 100 percent in year 3 (compared to year 2)}

\item{comp_ratio}{numeric vector of length 4 containing compensation ratio
(on average) of following insurances relative to Medicare: Medicare
(should be 1), Medicaid, Commercial (private), and Other (self-pay, bad
debt)}

\item{ins_prop}{numeric vector of length 4 containing proportion of
patients with following types of insurance: Medicare, Medicaid,
Commercial (private), and Other (self-pay, bad debt); sum of
this vector should equal unity}

\item{tech_fee_mult}{technical fee as a multiple of procedural fee}

\item{month_prop}{proportion of revenue expected in each of 12 months of
the year}

\item{restoration}{proportion of expected revenue expected in each of
36 upcoming months due to acute economic event being modeled}

\item{boost_amt}{boost amount for up to 8 procedure sets}

\item{boost_proc}{list of boost procedures for each of 8 boosts above}

\item{boost_start}{start month (between 1 and 36, inclusive) for each of
8 boosts above}

\item{boost_end}{end month (between 1 and 36, inclusive) for each of 8
boosts above}
}
\value{
list with 2 numeric vectors of length 36 each
}
\description{
Allows calculation of projected revenue for upcoming 36 months along with
target revenue for corresponding months.
}
\examples{

# sample dataset of procedures
eg_procs <- data.frame(Name = c("Sample 1", "Sample 2", "Sample 3"),
                       Revenue = c(100000, 200000, 150000),
                       Volume = 1000, 25, 750)

# calculate revenue projections for next 36 months with default parameters
proj <- calc_rev(eg_procs)

# print 36-month target revenues
print(proj$Target)

# print 36-month projected revenues
print(proj$Projected)
}
