% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{kannisto}
\alias{kannisto}
\title{Kannisto's Age Heaping Index}
\usage{
kannisto(x, Agei = 90, weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{Agei}{single age value to evaluate (default 90).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing Kannisto's index.
}
\description{
Kannisto's index compares the count at a specific age to a geometric
mean of surrounding ages, providing a measure of heaping that is
robust to exponentially declining populations at old ages.
}
\details{
Calculate Kannisto's index for detecting heaping at a specific old age.


Unlike other indices that use arithmetic means, Kannisto's index uses
geometric means of neighboring ages, which is more appropriate for
old-age populations where counts decline exponentially.

The index is calculated as the ratio of the count at age \code{Agei}
to the geometric mean of counts at ages \code{Agei-2} through
\code{Agei+2}.

Interpretation:
\itemize{
  \item 1.0: no heaping at the specified age
  \item >1.0: heaping (attraction to the age)
  \item <1.0: avoidance of the age
}
}
\examples{
# Create old-age data with heaping at 90
set.seed(42)
age <- c(sample(85:95, 2000, replace = TRUE),
         rep(90, 200))  # Add heaping at 90
kannisto(age, Agei = 90)  # Should be > 1

# No heaping
age_uniform <- sample(85:95, 2000, replace = TRUE)
kannisto(age_uniform, Agei = 90)  # Should be close to 1

}
\references{
Kannisto, V. (1999). Assessing the information on age at death of
old persons in national vital statistics. \emph{Validation of
Exceptional Longevity, Odense Monographs on Population Aging},
\strong{6}, 235-249.
}
\seealso{
\code{\link{jdanov}} for Jdanov's index,
  \code{\link{coale_li}} for Coale-Li index.

Other heaping indices: 
\code{\link{bachi}()},
\code{\link{coale_li}()},
\code{\link{heaping_indices}()},
\code{\link{jdanov}()},
\code{\link{myers}()},
\code{\link{noumbissi}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
