% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_heart.R
\name{pulse_choose_keep}
\alias{pulse_choose_keep}
\title{(\verb{STEP 6}) Choose the best heart beat frequency estimate from among two estimates derived from raw and smoothed data}
\usage{
pulse_choose_keep(heart_rates, lim_n = 3, lim_sd = 0.75)
}
\arguments{
\item{heart_rates}{the output from \code{\link[=pulse_heart]{pulse_heart()}}}

\item{lim_n}{numeric, defaults to \code{3}; minimum number of peaks detected in each time window for it to be considered a "keep".}

\item{lim_sd}{numeric, defaults to \code{0.75}; maximum value for the sd of the time intervals between each peak detected for it to be considered a "keep"}
}
\value{
A tibble with the same structure as the input, but now with only one estimate for each combination of \code{id} and \code{time} (the one that was deemed better).
}
\description{
\itemize{
\item \verb{step 1} -- \code{\link[=pulse_read]{pulse_read()}}
\item \verb{step 2} -- \code{\link[=pulse_split]{pulse_split()}}
\item \verb{step 3} -- \code{\link[=pulse_optimize]{pulse_optimize()}}
\item \verb{step 4} -- \code{\link[=pulse_heart]{pulse_heart()}}
\item \verb{step 5} -- \code{\link[=pulse_doublecheck]{pulse_doublecheck()}}
\item \strong{\verb{-->>} step 6 -- \code{\link[=pulse_choose_keep]{pulse_choose_keep()}} \verb{<<--}}
}

When running \code{\link[=pulse_optimize]{pulse_optimize()}} or \code{\link[=PULSE]{PULSE()}} with \code{raw_v_smoothed = TRUE}, two estimates are generated for each data point, and \code{pulse_choose_keep} is used to automatically select the best one (based on N and SD levels set by the user). NOTE: if supplied with input data generated using \code{raw_v_smoothed = FALSE}, \code{pulse_choose_keep} outputs the same data, unchanged.
}
\examples{
## Begin prepare data ----
pulse_data_sub <- pulse_data
pulse_data_sub$data <- pulse_data_sub$data[,1:2]
pulse_data_split <- pulse_split(pulse_data_sub)
pulse_data_split <- pulse_optimize(pulse_data_split, multi = pulse_data$multi)
heart_rates <- pulse_heart(pulse_data_split)
## End prepare data ----

nrow(heart_rates)
heart_rates <- pulse_choose_keep(heart_rates)
nrow(heart_rates) # halved
}
\seealso{
\itemize{
\item \code{\link[=pulse_read]{pulse_read()}}, \code{\link[=pulse_split]{pulse_split()}}, \code{\link[=pulse_optimize]{pulse_optimize()}}, \code{\link[=pulse_heart]{pulse_heart()}} and \code{\link[=pulse_doublecheck]{pulse_doublecheck()}} are the other functions needed for the complete PULSE processing workflow
\item \code{\link[=PULSE]{PULSE()}} is a wrapper function that executes all the steps needed to process PULSE data at once
}
}
