% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcanoPlot}
\alias{volcanoPlot}
\title{Create a volcano plot}
\usage{
volcanoPlot(
  df,
  title = NULL,
  logCol = "avg_log2FC",
  pvalCol = "p_val_adj",
  xLab = expression(log[2] ~ fold ~ change),
  yLab = expression(-log[10] ~ `p-value`),
  legendTitle = "Significance",
  legendLabs = c("Not significant", expression(log[2] ~ FC), "p-value",
    expression(`p-value` ~ and ~ log[2] ~ FC)),
  legendPos = c("right", "top", "left", "bottom"),
  logFCThr = 1,
  pvalThr = 1e-05,
  labeledGenes = NULL,
  labelOutside = FALSE,
  labLogFCThr = 1.8,
  labPvalThr = 1e-12,
  labelType = c("boxed", "free"),
  labelSize = 2.2,
  labelColor = "black",
  labelRepulsion = 1,
  labelPull = 0,
  maxOverlaps = 100,
  boxPadding = 0.2,
  labelPadding = 0.1,
  labelSegWidth = 0.4,
  pointSize = 0.8,
  alpha = 0.6,
  palette = c("gray31", "goldenrod2", "orchid3", "red2"),
  legendTextSize = 10,
  legendTitleSize = 10,
  axisTextSize = 12,
  axisTitleSize = 12,
  theme = c("minimal", "bw", "classic", "linedraw"),
  ...
)
}
\arguments{
\item{df}{A data frame with rownames as genes, a log column and a
p-value column.}

\item{title}{Plot title.}

\item{logCol}{Log column.}

\item{pvalCol}{P-value column.}

\item{xLab}{x axis label.}

\item{yLab}{y axis label.}

\item{legendTitle}{Legend title.}

\item{legendLabs}{Legend labels.}

\item{legendPos}{Legend position.}

\item{logFCThr}{Threshold used to separate significant log values.}

\item{pvalThr}{Threshold used to separate significant p-values.}

\item{labeledGenes}{Gene labels to be displayed on the plot. Default is
\code{NULL}, entailing that gene labels will be displayed on the basis
of \code{labLogFCThr} and \code{labPvalThr}, if at least one of
them is not \code{NULL}.}

\item{labelOutside}{Display labels for points specified by
\code{labeledGenes} even if they fall outside the boundaries imposed by
\code{labLogFCThr} and \code{labPvalThr}. Ignored if \code{labeledGenes} is
\code{NULL} or both \code{labLogFCThr} and \code{labPvalThr} are \code{NULL}.}

\item{labLogFCThr}{Threshold used to plot gene labels based on log values.
Ignored if \code{labeledGenes} is not \code{NULL}.}

\item{labPvalThr}{Threshold used to plot gene labels based on p-values.
Ignored if \code{labeledGenes} is not \code{NULL}.}

\item{labelType}{Whether to draw a box around labels (option 'boxed') or not
(option 'free'). Default is 'free'.}

\item{labelSize}{Label size.}

\item{labelColor}{Label color.}

\item{labelRepulsion}{Repulsion strength between labels.}

\item{labelPull}{Attraction strength between a text label
and its data point.}

\item{maxOverlaps}{Maximum number of allowed overlaps.}

\item{boxPadding}{Amount of padding around box.}

\item{labelPadding}{Amount of padding around label.}

\item{labelSegWidth}{Thickness of segment connecting label to point.}

\item{pointSize}{Point size.}

\item{alpha}{Opaqueness level of point color.}

\item{palette}{Color palette.}

\item{legendTextSize}{Legend text size.}

\item{legendTitleSize}{Legend title size.}

\item{axisTextSize}{Axis text size.}

\item{axisTitleSize}{Axis title size.}

\item{theme}{Plot theme. Choose between 'bw', 'classic', 'linedraw'
and 'minimal'. Default is 'minimal'.}

\item{...}{Additional arguments passed to
\code{EnhancedVolcano::EnhancedVolcano}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function creates a volcano plot for a data frame with a log column and
a p-value column. The gene names must be provided as row names.
}
\details{
Users can input labeled genes in two ways:

1) By using p-value and log fold-change thresholds (the default option).

2) By inputting a list of labels.
}
\examples{
if (requireNamespace("EnhancedVolcano", quietly=TRUE)){
filePath <- system.file('extdata', 'volcanoPlot.qs2', package='henna')
df <- qs2::qs_read(filePath)
p <- volcanoPlot(df, title='Volcano plot - beta cells', pvalThr=1e-10,
logFCThr=1,
labPvalThr=1e-150,
labLogFCThr=5.3)
}

}
