% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tparams_mean.R
\name{summary.tparams_mean}
\alias{summary.tparams_mean}
\alias{print.tparams_mean}
\title{Summarize \code{tparams_mean} object}
\usage{
\method{summary}{tparams_mean}(object, probs = c(0.025, 0.975), ...)

\method{print}{tparams_mean}(x, ...)
}
\arguments{
\item{object, x}{A \code{\link{tparams_mean}} object.}

\item{probs}{A numeric vector of probabilities with values in \verb{[0,1]} used
to compute quantiles. By default, the 2.5th and 97.5th percentiles are
computed.}

\item{...}{Currently unused.}
}
\value{
A \code{data.table} with columns for (i) the ID variables,
(ii) the mean of each parameter across parameter samples (\code{mean}),
(iii) the standard deviation of the parameter samples (\code{sd}), and
(iv) quantiles of the parameter samples corresponding to the \code{probs} argument.
}
\description{
The \code{summary()} method summarizes a \code{\link{tparams_mean}} object containing
predicted means; summary statistics are computed for each
combination of the ID variables. The \code{print()} method
summarizes the object using \code{summary.tparams_mean()} and prints it to the
console.
}
\seealso{
See \code{\link{tparams_mean}} for an example use of the summary and
print methods.
}
