% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpin.R
\name{rpin}
\alias{rpin}
\alias{rhetu}
\title{Generate Random Personal Identity Codes}
\usage{
rpin(
  n,
  start.date = as.Date("1895-01-01"),
  end.date = Sys.Date(),
  p.male = 0.4,
  p.temp = 0,
  num.cores = 1
)

rhetu(
  n,
  start.date = as.Date("1895-01-01"),
  end.date = Sys.Date(),
  p.male = 0.4,
  p.temp = 0,
  num.cores = 1
)
}
\arguments{
\item{n}{number of generated \code{hetu}-pins}

\item{start.date}{Lower limit of generated \code{hetu} dates,
character string in ISO 8601 standard, for example "2001-02-03".
Default is "1895-01-01".}

\item{end.date}{Upper limit of generated \code{hetu}.
Default is current date.}

\item{p.male}{Probability of males, between 0.0 and 1.0. Default is 0.4.}

\item{p.temp}{Probability of temporary identification numbers, between
0.0 and 1.0. Default is 0.0.}

\item{num.cores}{The number of cores for parallel processing. The number
of available cores can be determined with \code{detectCores()}.
Default is 1.}
}
\value{
a vector of generated \code{hetu}-pins.
}
\description{
A function that generates random Finnish personal identity codes
   (\code{hetu} codes).
}
\details{
This function will return an error "too few positive probabilities" in
\code{\link{sample.int}} function if you try to generate too many codes
in a short enough timeframe. The theoretical upper limit of valid PINs is
in the millions, but the number of valid PINs per day used to be 898 PINs
at maximum, meaning 327770 for each year. Attempting to generate e.g.
a 1000 pins for a timespan of one day would result in an error.

In practice this theoretical upper limit number was
much lower since the old practice was that the same personal number
component cannot be "recycled" if it has been used in the past.
To illustrate, if an identity code "010101-0101" has already been assigned
to someone born in 1901-01-01, a similar code "010101A0101" for someone
born in 2001-01-01 could not be used.

In hetu package version 1.1.0 we have taken into account a new government
decree that increased the amount of valid century markers and therefore
increased the amount of valid personal codes per day. Additionally, the
decree has made it possible to recycle individual codes, as the century
marker is now thought to be a distinguishing character of the personal
identity code.

However, the current implementation still keeps the old 898 codes per day
limit intact, and assigns new century markers with a low probability: old
markers "-" and "A" are given a 95 % probability of appearing and the new
markers are given a 1 % probability each.

In the future this may be altered
into a waterfall pattern so that the initial 898 codes for each date
get "-" as the century marker, the next 898 get "Y", and so on.
This would mean that each day would have 5388 valid codes and the
distribution of century markers would be more
realistic in the sense that additional century markers are taken into use
only after the previous range has been exhausted. However, this would
require generating rather large datasets even for basic testing purposes.
}
\examples{
x <- rpin(3)
hetu(x)
hetu(x, extract = "sex")
hetu(x, extract = "ctrl.char")

x <- rhetu(3)
x
}
\author{
Pyry Kantanen, Jussi Paananen
}
