#include <Rcpp.h>
#include "Log.h"

namespace hipo {

Log::Log(Int level) : dev_level_{level} {}

void Log::print(std::stringstream& ss) const { Rprintf("%s", ss.str().c_str()); }
void Log::printw(std::stringstream& ss) const {
  Rprintf("WARNING: %s", ss.str().c_str());
}
void Log::printe(std::stringstream& ss) const {
  Rprintf("ERROR: %s", ss.str().c_str());
}
void Log::print(const char* c) const { Rprintf("%s", c); }
void Log::printw(const char* c) const { Rprintf("WARNING: %s", c); }
void Log::printe(const char* c) const { Rprintf("ERROR: %s", c); }
void Log::printDevInfo(std::stringstream& ss) const {
  if (dev_level_ >= 1) Rprintf("%s", ss.str().c_str());
}
void Log::printDevDetailed(std::stringstream& ss) const {
  if (dev_level_ >= 2) Rprintf("%s", ss.str().c_str());
}
void Log::printDevVerbose(std::stringstream& ss) const {
  if (dev_level_ >= 3) Rprintf("%s", ss.str().c_str());
}
void Log::printDevInfo(const char* c) const {
  if (dev_level_ >= 1) Rprintf("%s", c);
}
void Log::printDevDetailed(const char* c) const {
  if (dev_level_ >= 2) Rprintf("%s", c);
}
void Log::printDevVerbose(const char* c) const {
  if (dev_level_ >= 3) Rprintf("%s", c);
}
bool Log::debug(Int level) const {
  // Return true if level agrees with dev_level
  if (dev_level_ == 1) return level == 1;
  if (dev_level_ == 2) return level == 1 || level == 2;
  if (dev_level_ == 3) return level == 1 || level == 2 || level == 3;
  return false;
}

std::string format(double d, Int width, Int prec,
                   std::ios_base::fmtflags floatfield) {
  std::ostringstream s;
  s.precision(prec);
  s.width(width);
  s.setf(floatfield, std::ios_base::floatfield);
  s << d;
  return s.str();
}

std::string integer(Int i, Int width) {
  std::ostringstream s;
  s.width(width);
  s << i;
  return s.str();
}

}  // namespace hipo
