% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_hirisplex_csv.R
\name{write_hirisplex_csv}
\alias{write_hirisplex_csv}
\title{Write HIrisPlex / HIrisPlex-S CSV from a PLINK BED/BIM/FAM prefix}
\usage{
write_hirisplex_csv(
  prefix,
  out,
  panel = c("hirisplexs", "hirisplex", "irisplex"),
  sample_id = c("IID", "FID_IID"),
  allow_strand_flip = TRUE
)
}
\arguments{
\item{prefix}{Character. Path prefix to PLINK files, without extension.}

\item{out}{Character. Output CSV path.}

\item{panel}{Character. One of "hirisplexs" (default), "hirisplex", "irisplex".#'}

\item{sample_id}{Character. How to form 'SampleID': "IID" or "FID_IID".
Default is "IID".}

\item{allow_strand_flip}{Logical. If TRUE, attempt to match the required
allele by allowing strand complements.}
}
\value{
(Invisibly) the output file path.
}
\description{
Given a PLINK 1.9 binary dataset (prefix.bed/.bim/.fam), this function
produces a CSV ready to upload to the HIrisPlex(-S) webtool.
}
\details{
Columns are 'SampleID' followed by one column per required SNP in the form
\code{rsID_Allele} (e.g., \code{rs12203592_T}). Each cell contains 0/1/2 (count of the
input allele) or NA when the SNP is missing. The column set and order are
defined by the selected panel (IrisPlex, HIrisPlex, HIrisPlex-S).

Allele counting is based on the PLINK .bim alleles. Genotype dosage is read
on demand from the .bed using \code{\link[BEDMatrix:BEDMatrix]{BEDMatrix::BEDMatrix()}}, which encodes the
dosage of the first allele in the .bim file (A1). If the webtool's required
input allele equals A1, we use the dosage directly; if it equals A2, we use
(2 - dosage). If \code{allow_strand_flip = TRUE}, we also reconcile complements
(A<->T, C<->G) to account for strand orientation differences.
}
\examples{
\dontrun{
write_hirisplex_csv("/path/to/prefix", tempfile(fileext = ".csv"), panel = "hirisplexs")
}
}
