% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multvar.R
\name{sim_missing}
\alias{sim_missing}
\title{Simulate missing values}
\usage{
sim_missing(.data, prop, seed = NA)
}
\arguments{
\item{.data}{A dataframe.}

\item{prop}{Proportion of values to be set to `NA`.}

\item{seed}{An optional seed for random number generation.  If `NA` (default) a random seed will be used.}
}
\value{
a dataframe with NAs
}
\description{
Takes a data frame and randomly replaces a user-supplied proportion of values with `NA`.
}
\examples{
library(dplyr)
df <- sim_cat(n_obs = 10, n_groups = 2) \%>\%
sim_covar(n_vars = 10, var = 1, cov = 0.5) \%>\%
sim_missing(0.05)
}
